/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.properties;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;

public class R2dbcMybatisProperties {
    public static final String PREFIX = "r2dbc.mybatis";
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String[] mapperLocations;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private String r2dbcTypeHandlerAdapterPackage;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    private Class<? extends TypeHandler<?>> defaultEnumTypeHandler;
    @NestedConfigurationProperty
    private R2dbcMybatisConfiguration configuration;

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public Class<?>[] getTypeAliases() {
        return this.typeAliases;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public String getR2dbcTypeHandlerAdapterPackage() {
        return this.r2dbcTypeHandlerAdapterPackage;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Class<? extends TypeHandler<?>> getDefaultEnumTypeHandler() {
        return this.defaultEnumTypeHandler;
    }

    public R2dbcMybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setR2dbcTypeHandlerAdapterPackage(String r2dbcTypeHandlerAdapterPackage) {
        this.r2dbcTypeHandlerAdapterPackage = r2dbcTypeHandlerAdapterPackage;
    }

    public void setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setDefaultEnumTypeHandler(Class<? extends TypeHandler<?>> defaultEnumTypeHandler) {
        this.defaultEnumTypeHandler = defaultEnumTypeHandler;
    }

    public void setConfiguration(R2dbcMybatisConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return "R2dbcMybatisProperties(mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliases=" + Arrays.deepToString(this.getTypeAliases()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeAliasesSuperType=" + this.getTypeAliasesSuperType() + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", r2dbcTypeHandlerAdapterPackage=" + this.getR2dbcTypeHandlerAdapterPackage() + ", defaultScriptingLanguageDriver=" + this.getDefaultScriptingLanguageDriver() + ", configurationProperties=" + this.getConfigurationProperties() + ", defaultEnumTypeHandler=" + this.getDefaultEnumTypeHandler() + ", configuration=" + this.getConfiguration() + ")";
    }
}

