/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.xml;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.spring.mapper.R2dbcMapperScannerConfigurer;

public class R2dbcMapperScannerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String ATTRIBUTE_BASE_PACKAGE = "base-package";
    private static final String ATTRIBUTE_ANNOTATION = "annotation";
    private static final String ATTRIBUTE_MARKER_INTERFACE = "marker-interface";
    private static final String ATTRIBUTE_NAME_GENERATOR = "name-generator";
    private static final String ATTRIBUTE_FACTORY_REF = "factory-ref";
    private static final String ATTRIBUTE_MAPPER_FACTORY_BEAN_CLASS = "mapper-factory-bean-class";
    private static final String ATTRIBUTE_LAZY_INITIALIZATION = "lazy-initialization";
    private static final String ATTRIBUTE_DEFAULT_SCOPE = "default-scope";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(R2dbcMapperScannerConfigurer.class);
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
        try {
            String mapperFactoryBeanClassName;
            String nameGeneratorClassName;
            String markerInterfaceClassName;
            String annotationClassName = element.getAttribute(ATTRIBUTE_ANNOTATION);
            if (StringUtils.hasText((String)annotationClassName)) {
                Class<?> annotationClass = classLoader.loadClass(annotationClassName);
                builder.addPropertyValue("annotationClass", annotationClass);
            }
            if (StringUtils.hasText((String)(markerInterfaceClassName = element.getAttribute(ATTRIBUTE_MARKER_INTERFACE)))) {
                Class<?> markerInterface = classLoader.loadClass(markerInterfaceClassName);
                builder.addPropertyValue("markerInterface", markerInterface);
            }
            if (StringUtils.hasText((String)(nameGeneratorClassName = element.getAttribute(ATTRIBUTE_NAME_GENERATOR)))) {
                Class<?> nameGeneratorClass = classLoader.loadClass(nameGeneratorClassName);
                BeanNameGenerator nameGenerator = (BeanNameGenerator)BeanUtils.instantiateClass(nameGeneratorClass, BeanNameGenerator.class);
                builder.addPropertyValue("nameGenerator", (Object)nameGenerator);
            }
            if (StringUtils.hasText((String)(mapperFactoryBeanClassName = element.getAttribute(ATTRIBUTE_MAPPER_FACTORY_BEAN_CLASS)))) {
                Class<?> mapperFactoryBeanClass = classLoader.loadClass(mapperFactoryBeanClassName);
                builder.addPropertyValue("mapperFactoryBeanClass", mapperFactoryBeanClass);
            }
        }
        catch (Exception ex) {
            XmlReaderContext readerContext = parserContext.getReaderContext();
            readerContext.error(ex.getMessage(), readerContext.extractSource((Object)element), ex.getCause());
        }
        builder.addPropertyValue("sqlSessionFactoryBeanName", (Object)element.getAttribute(ATTRIBUTE_FACTORY_REF));
        builder.addPropertyValue("lazyInitialization", (Object)element.getAttribute(ATTRIBUTE_LAZY_INITIALIZATION));
        builder.addPropertyValue("defaultScope", (Object)element.getAttribute(ATTRIBUTE_DEFAULT_SCOPE));
        builder.addPropertyValue("basePackage", (Object)element.getAttribute(ATTRIBUTE_BASE_PACKAGE));
        return builder.getBeanDefinition();
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

