package pro.flashup.client

import dev.kaccelero.client.AbstractAPIClient
import dev.kaccelero.commons.auth.IGetTokenUseCase
import dev.kaccelero.commons.auth.ILogoutUseCase
import dev.kaccelero.commons.auth.IRenewTokenUseCase
import io.ktor.http.*
import pro.flashup.models.application.FlashUpEnvironment
import pro.flashup.repositories.auth.AuthAPIRemoteRepository
import pro.flashup.repositories.community.CommunityRemoteRepository
import pro.flashup.repositories.topics.TopicsRemoteRepository
import pro.flashup.repositories.users.UsersRemoteRepository

class FlashUpClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: FlashUpEnvironment = FlashUpEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase
), IFlashUpClient {

    override val auth = AuthAPIRemoteRepository(this)
    override val topics = TopicsRemoteRepository(this)
    override val users = UsersRemoteRepository(this)
    override val community = CommunityRemoteRepository(this)

    override fun shouldIncludeToken(method: HttpMethod, path: String): Boolean {
        // Don't include token for refresh token endpoint (to avoid infinite loop)
        return path != "/api/v1/auth/refresh"
    }

}
