package pro.flashup.repositories.community

import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIUnitRemoteRepository
import dev.kaccelero.repositories.IPaginationOptions
import dev.kaccelero.repositories.Pagination
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import pro.flashup.client.IFlashUpClient
import pro.flashup.models.application.SearchOptions
import pro.flashup.models.community.CommunitySection

class CommunityRemoteRepository(
    client: IFlashUpClient,
) : APIUnitRemoteRepository(
    client,
    route = "community",
    prefix = "/api/v1"
), ICommunityRemoteRepository {

    override fun HttpRequestBuilder.encodePaginationOptions(options: IPaginationOptions) = when (options) {
        is SearchOptions -> parameter("search", options.search)
        else -> {}
    }

    override suspend fun listSections(pagination: Pagination): List<CommunitySection> = client.request(
        HttpMethod.Get,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/sections"
    ) {
        encodePagination(pagination)
    }.body()

}
