package pro.flashup.models.auth

import dev.kaccelero.models.IModel
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class AuthCode(
    val code: String,
    val type: AuthCodeType,
    val data: String?,
    val expiresAt: Instant,
) : IModel<String, CreateAuthCodePayload, Unit> {

    override val id: String
        get() = code

}
