package pro.flashup.models.cards

import dev.kaccelero.annotations.PayloadProperty
import dev.kaccelero.annotations.Schema
import kotlinx.serialization.Serializable

@Serializable
data class CreateCardPayload(
    @PayloadProperty("string")
    @Schema("Name of the card", "My card")
    val name: String,
    @PayloadProperty("string")
    @Schema("Front text of the card", "Hello")
    val frontText: String?,
    @PayloadProperty("string")
    @Schema("Back text of the card", "World")
    val backText: String,
)
