package pro.flashup.models.cards

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Card(
    @ModelProperty("id")
    @Schema("Id of the card", "123abc")
    override val id: UUID,
    @Schema("Id of the topic the card is in", "123abc")
    val topicId: UUID,
    @ModelProperty("string")
    @Schema("Name of the card", "My card")
    val name: String,
    @ModelProperty("string")
    @Schema("Front text of the card", "Hello")
    val frontText: String?,
    @ModelProperty("string")
    @Schema("Back text of the card", "World")
    val backText: String,
) : IChildModel<UUID, CreateCardPayload, UpdateCardPayload, UUID> {

    override val parentId: UUID
        get() = topicId

}
