package pro.flashup.repositories.topics

import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import pro.flashup.client.IFlashUpClient
import pro.flashup.models.topics.*

class TopicsRemoteRepository(
    client: IFlashUpClient,
) : APIModelRemoteRepository<Topic, UUID, CreateTopicPayload, UpdateTopicPayload>(
    typeInfo<Topic>(),
    typeInfo<CreateTopicPayload>(),
    typeInfo<UpdateTopicPayload>(),
    typeInfo<List<Topic>>(),
    client,
    prefix = "/api/v1"
), ITopicsRemoteRepository {

    override suspend fun export(id: UUID): TopicWithCards? = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/export")
        .body()

    override suspend fun import(payload: CreateTopicWithCardsPayload): TopicWithCards? = client
        .request(HttpMethod.Post, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/import") {
            contentType(ContentType.Application.Json)
            setBody(payload)
        }.body()

}
