package pro.flashup.models.users

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.IUser
import dev.kaccelero.models.UUID
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class User(
    @Schema("Id of the User", "123abc")
    override val id: UUID,
    @Schema("Email of the User", "nathan@guimauve.software")
    val email: String,
    val password: String?,
    @Schema("Name of the User", "Nathan")
    val name: String,
    @Schema("Biography of the User", "Hello, I'm Nathan Fallet, a software engineer.")
    val biography: String,
    @Schema("Image of the User", "https://example.com/image.jpg")
    val image: String?,
    @Schema("Last login date of the User", "2021-01-01T00:00:00Z")
    val lastLoginAt: Instant,
) : IModel<UUID, CreateUserPayload, UpdateUserPayload>, IUser {

    companion object {

        const val EMAIL_REGEX = "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}"

    }

}
