/*
 * Decompiled with CFR 0.152.
 */
package pro.flashup.client;

import dev.kaccelero.client.AbstractAPIClient;
import dev.kaccelero.commons.auth.IGetTokenUseCase;
import dev.kaccelero.commons.auth.ILogoutUseCase;
import dev.kaccelero.commons.auth.IRenewTokenUseCase;
import io.ktor.http.HttpMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pro.flashup.client.IFlashUpClient;
import pro.flashup.models.application.FlashUpEnvironment;
import pro.flashup.repositories.auth.AuthAPIRemoteRepository;
import pro.flashup.repositories.community.CommunityRemoteRepository;
import pro.flashup.repositories.topics.TopicsRemoteRepository;
import pro.flashup.repositories.users.UsersRemoteRepository;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lpro/flashup/client/FlashUpClient;", "Ldev/kaccelero/client/AbstractAPIClient;", "Lpro/flashup/client/IFlashUpClient;", "getTokenUseCase", "Ldev/kaccelero/commons/auth/IGetTokenUseCase;", "renewTokenUseCase", "Ldev/kaccelero/commons/auth/IRenewTokenUseCase;", "logoutUseCase", "Ldev/kaccelero/commons/auth/ILogoutUseCase;", "environment", "Lpro/flashup/models/application/FlashUpEnvironment;", "<init>", "(Ldev/kaccelero/commons/auth/IGetTokenUseCase;Ldev/kaccelero/commons/auth/IRenewTokenUseCase;Ldev/kaccelero/commons/auth/ILogoutUseCase;Lpro/flashup/models/application/FlashUpEnvironment;)V", "auth", "Lpro/flashup/repositories/auth/AuthAPIRemoteRepository;", "getAuth", "()Lpro/flashup/repositories/auth/AuthAPIRemoteRepository;", "topics", "Lpro/flashup/repositories/topics/TopicsRemoteRepository;", "getTopics", "()Lpro/flashup/repositories/topics/TopicsRemoteRepository;", "users", "Lpro/flashup/repositories/users/UsersRemoteRepository;", "getUsers", "()Lpro/flashup/repositories/users/UsersRemoteRepository;", "community", "Lpro/flashup/repositories/community/CommunityRemoteRepository;", "getCommunity", "()Lpro/flashup/repositories/community/CommunityRemoteRepository;", "shouldIncludeToken", "", "method", "Lio/ktor/http/HttpMethod;", "path", "", "commons"})
public final class FlashUpClient
extends AbstractAPIClient
implements IFlashUpClient {
    @NotNull
    private final AuthAPIRemoteRepository auth;
    @NotNull
    private final TopicsRemoteRepository topics;
    @NotNull
    private final UsersRemoteRepository users;
    @NotNull
    private final CommunityRemoteRepository community;

    public FlashUpClient(@NotNull IGetTokenUseCase getTokenUseCase, @NotNull IRenewTokenUseCase renewTokenUseCase, @NotNull ILogoutUseCase logoutUseCase, @NotNull FlashUpEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)getTokenUseCase, (String)"getTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)renewTokenUseCase, (String)"renewTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)logoutUseCase, (String)"logoutUseCase");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(environment.getBaseUrl(), getTokenUseCase, renewTokenUseCase, logoutUseCase, null, null, null, 112, null);
        this.auth = new AuthAPIRemoteRepository(this);
        this.topics = new TopicsRemoteRepository(this);
        this.users = new UsersRemoteRepository(this);
        this.community = new CommunityRemoteRepository(this);
    }

    public /* synthetic */ FlashUpClient(IGetTokenUseCase iGetTokenUseCase, IRenewTokenUseCase iRenewTokenUseCase, ILogoutUseCase iLogoutUseCase, FlashUpEnvironment flashUpEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            flashUpEnvironment = FlashUpEnvironment.PRODUCTION;
        }
        this(iGetTokenUseCase, iRenewTokenUseCase, iLogoutUseCase, flashUpEnvironment);
    }

    @Override
    @NotNull
    public AuthAPIRemoteRepository getAuth() {
        return this.auth;
    }

    @Override
    @NotNull
    public TopicsRemoteRepository getTopics() {
        return this.topics;
    }

    @Override
    @NotNull
    public UsersRemoteRepository getUsers() {
        return this.users;
    }

    @Override
    @NotNull
    public CommunityRemoteRepository getCommunity() {
        return this.community;
    }

    public boolean shouldIncludeToken(@NotNull HttpMethod method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !Intrinsics.areEqual((Object)path, (Object)"/api/v1/auth/refresh");
    }
}

