/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;

public class ClientPermissions {
    public static final ClientPermissions DEFAULT = new ClientPermissions();
    @LauncherNetworkAPI
    public long permissions;
    @LauncherNetworkAPI
    public long flags;

    public ClientPermissions(HInput input) throws IOException {
        this(input.readLong());
    }

    public ClientPermissions() {
    }

    public ClientPermissions(long permissions) {
        this.permissions = permissions;
    }

    public ClientPermissions(long permissions, long flags) {
        this.permissions = permissions;
        this.flags = flags;
    }

    public static ClientPermissions getSuperuserAccount() {
        ClientPermissions perm = new ClientPermissions();
        perm.setPermission(PermissionConsts.ADMIN, true);
        return perm;
    }

    public long toLong() {
        return this.permissions;
    }

    @Deprecated
    public void write(HOutput output) throws IOException {
        output.writeLong(this.toLong());
    }

    public final boolean isPermission(PermissionConsts con) {
        return (this.permissions & con.mask) != 0L;
    }

    public final boolean isPermission(long mask) {
        return (this.permissions & mask) != 0L;
    }

    public final boolean isFlag(FlagConsts con) {
        return (this.flags & con.mask) != 0L;
    }

    public final boolean isFlag(long mask) {
        return (this.flags & mask) != 0L;
    }

    public final void setPermission(PermissionConsts con, boolean value) {
        this.permissions = value ? (this.permissions |= con.mask) : (this.permissions &= con.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setPermission(long mask, boolean value) {
        this.permissions = value ? (this.permissions |= mask) : (this.permissions &= mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setFlag(FlagConsts con, boolean value) {
        this.flags = value ? (this.flags |= con.mask) : (this.flags &= con.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setFlag(long mask, boolean value) {
        this.flags = value ? (this.flags |= mask) : (this.flags &= mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        return "ClientPermissions{permissions=" + this.permissions + ", flags=" + this.flags + '}';
    }

    public static enum PermissionConsts {
        ADMIN(1L),
        MANAGEMENT(2L);

        public final long mask;

        private PermissionConsts(long mask) {
            this.mask = mask;
        }
    }

    public static enum FlagConsts {
        SYSTEM(1L),
        BANNED(2L),
        UNTRUSTED(4L),
        HIDDEN(8L);

        public final long mask;

        private FlagConsts(long mask) {
            this.mask = mask;
        }
    }
}

