/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.events.ExceptionEvent;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.ClientWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdWebSocketService
extends ClientWebSocketService {
    private final ConcurrentHashMap<UUID, CompletableFuture> futureMap = new ConcurrentHashMap();
    private final HashSet<ClientWebSocketService.EventHandler> eventHandlers = new HashSet();

    public StdWebSocketService(String address) throws SSLException {
        super(address);
    }

    public static StdWebSocketService initWebSockets(String address, boolean async) {
        StdWebSocketService service;
        try {
            service = new StdWebSocketService(address);
        }
        catch (SSLException e) {
            throw new SecurityException(e);
        }
        service.registerResults();
        service.registerRequests();
        if (!async) {
            try {
                service.open();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        } else {
            service.openAsync(() -> {});
        }
        JVMHelper.RUNTIME.addShutdownHook(new Thread(() -> {
            try {
                service.close();
            }
            catch (InterruptedException e) {
                LogHelper.error((Throwable)e);
            }
        }));
        return service;
    }

    public void registerEventHandler(ClientWebSocketService.EventHandler handler) {
        this.eventHandlers.add(handler);
    }

    public void unregisterEventHandler(ClientWebSocketService.EventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    public <T extends WebSocketEvent> void processEventHandlers(T event) {
        for (ClientWebSocketService.EventHandler handler : this.eventHandlers) {
            if (!handler.eventHandle(event)) continue;
            return;
        }
    }

    @Override
    public <T extends WebSocketEvent> void eventHandle(T webSocketEvent) {
        if (webSocketEvent instanceof RequestEvent) {
            RequestEvent event = (RequestEvent)webSocketEvent;
            if (event.requestUUID == null) {
                LogHelper.warning((String)"Request event type %s.requestUUID is null", (Object[])new Object[]{event.getType() == null ? "null" : event.getType()});
                return;
            }
            if (event.requestUUID.equals(RequestEvent.eventUUID)) {
                this.processEventHandlers(webSocketEvent);
                return;
            }
            CompletableFuture future = this.futureMap.get(event.requestUUID);
            if (future != null) {
                if (event instanceof ErrorRequestEvent) {
                    future.completeExceptionally(new RequestException(((ErrorRequestEvent)event).error));
                } else if (event instanceof ExceptionEvent) {
                    future.completeExceptionally(new RequestException(String.format("LaunchServer internal error: %s %s", ((ExceptionEvent)event).clazz, ((ExceptionEvent)event).message)));
                } else {
                    future.complete(event);
                }
                this.futureMap.remove(event.requestUUID);
            } else {
                this.processEventHandlers(event);
                return;
            }
        }
        this.processEventHandlers(webSocketEvent);
    }

    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) throws IOException {
        CompletableFuture result = new CompletableFuture();
        this.futureMap.put(request.requestUUID, result);
        this.sendObject(request, (Type)((Object)WebSocketRequest.class));
        return result;
    }

    public <T extends WebSocketEvent> T requestSync(Request<T> request) throws IOException {
        try {
            return (T)((WebSocketEvent)this.request(request).get());
        }
        catch (InterruptedException e) {
            throw new RequestException("Request interrupted");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RequestException(cause);
        }
    }
}

