/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class ConfigManager {
    private final HashMap<String, JsonConfigurable> CONFIGURABLE = new HashMap();

    public void registerConfigurable(String name, JsonConfigurable reconfigurable) {
        VerifyHelper.putIfAbsent(this.CONFIGURABLE, (Object)name.toLowerCase(), (Object)Objects.requireNonNull(reconfigurable, "adapter"), (String)String.format("Reloadable has been already registered: '%s'", name));
    }

    public void printConfigurables() {
        LogHelper.info((String)"Print configurables");
        this.CONFIGURABLE.forEach((k, v) -> LogHelper.subInfo((String)k));
        LogHelper.info((String)"Found %d configurables", (Object[])new Object[]{this.CONFIGURABLE.size()});
    }

    public void save(String name) throws IOException {
        this.CONFIGURABLE.get(name).saveConfig();
    }

    public void load(String name) throws IOException {
        this.CONFIGURABLE.get(name).loadConfig();
    }

    public void save(String name, Path path) throws IOException {
        this.CONFIGURABLE.get(name).saveConfig(path);
    }

    public void reset(String name) throws IOException {
        this.CONFIGURABLE.get(name).resetConfig();
    }

    public void load(String name, Path path) throws IOException {
        this.CONFIGURABLE.get(name).loadConfig(path);
    }

    public void reset(String name, Path path) throws IOException {
        this.CONFIGURABLE.get(name).resetConfig(path);
    }
}

