/*
 * Decompiled with CFR 0.152.
 */
package pro.leaco.console.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.leaco.console.qrcode.ConsoleQrcode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002JH\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000626\u0010\"\u001a2\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\n0#H\u0002J\u000e\u0010)\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001bH\u0002J(\u0010,\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00062\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010.H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u000e\u00102\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\"\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00105\u001a\u0004\u0018\u000106H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lpro/leaco/console/qrcode/ConsoleQrcode;", "", "()V", "ALPHANUMERIC_TABLE", "", "BLACK", "", "DEFAULT_BYTE_MODE_ENCODING", "WHITE", "append8BitBytes", "", "content", "bits", "Lcom/google/zxing/common/BitArray;", "encoding", "appendAlphanumericBytes", "", "appendBytes", "mode", "Lcom/google/zxing/qrcode/decoder/Mode;", "appendECI", "eci", "Lcom/google/zxing/common/CharacterSetECI;", "appendKanjiBytes", "appendModeInfo", "appendNumericBytes", "calculateBitsNeeded", "", "headerBits", "dataBits", "version", "Lcom/google/zxing/qrcode/decoder/Version;", "chooseMode", "generateQrcodeBitMatrix", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "maxWidth", "Lcom/google/zxing/common/BitMatrix;", "bitMatrix", "generateUnicodeQrcode", "getAlphanumericCode", "code", "getVersion", "hints", "", "Lcom/google/zxing/EncodeHintType;", "isOnlyDoubleByteKanji", "", "print", "willFit", "numInputBits", "ecLevel", "Lcom/google/zxing/qrcode/decoder/ErrorCorrectionLevel;", "console-qrcode"})
public final class ConsoleQrcode {
    @NotNull
    public static final ConsoleQrcode INSTANCE = new ConsoleQrcode();
    @NotNull
    private static String BLACK = "\u001b[40m  \u001b[0m";
    @NotNull
    private static String WHITE = "\u001b[47m  \u001b[0m";
    @NotNull
    private static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";
    @NotNull
    private static final int[] ALPHANUMERIC_TABLE;

    private ConsoleQrcode() {
    }

    public final void print(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.generateQrcodeBitMatrix(content, (Function2<? super Integer, ? super BitMatrix, Unit>)((Function2)print.1.INSTANCE));
    }

    @NotNull
    public final String generateUnicodeQrcode(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder r = new StringBuilder();
        this.generateQrcodeBitMatrix(content, (Function2<? super Integer, ? super BitMatrix, Unit>)((Function2)new Function2<Integer, BitMatrix, Unit>(r){
            final /* synthetic */ StringBuilder $r;
            {
                this.$r = $r;
                super(2);
            }

            public final void invoke(int maxWidth, @NotNull BitMatrix bitMatrix) {
                Intrinsics.checkNotNullParameter((Object)bitMatrix, (String)"bitMatrix");
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(maxWidth - 1))), (int)2);
                int i = intProgression.getFirst();
                int n = intProgression.getLast();
                int n2 = intProgression.getStep();
                if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                    while (true) {
                        for (int j = 0; j < maxWidth; ++j) {
                            char c;
                            int t = bitMatrix.get(i, j) ? 2 : 0;
                            int b = bitMatrix.get(i + 1, j) ? 1 : 0;
                            int s = t + b;
                            switch (s) {
                                case 0: {
                                    c = ' ';
                                    break;
                                }
                                case 2: {
                                    c = '\u2580';
                                    break;
                                }
                                case 1: {
                                    c = '\u2584';
                                    break;
                                }
                                case 3: {
                                    c = '\u2588';
                                    break;
                                }
                                default: {
                                    StringBuilder stringBuilder = new StringBuilder().append("impossible map: ");
                                    String string = Integer.toString(s, CharsKt.checkRadix((int)2));
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                                    throw new Error(stringBuilder.append(string).toString());
                                }
                            }
                            char c2 = c;
                            this.$r.append(c2);
                        }
                        this.$r.append('\n');
                        if (i == n) break;
                        i += n2;
                    }
                }
            }
        }));
        String string = r.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"r.toString()");
        return string;
    }

    private final void generateQrcodeBitMatrix(String content, Function2<? super Integer, ? super BitMatrix, Unit> block) {
        Map hints = new EnumMap(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        int maxWidth = 8;
        try {
            maxWidth += this.getVersion(content, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        int width = maxWidth;
        int height = maxWidth;
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        Integer n = maxWidth;
        Intrinsics.checkNotNullExpressionValue((Object)bitMatrix, (String)"bitMatrix");
        block.invoke((Object)n, (Object)bitMatrix);
    }

    private final int getVersion(String content, Map<EncodeHintType, ? extends Object> hints) throws WriterException {
        CharacterSetECI eci;
        String encoding = DEFAULT_BYTE_MODE_ENCODING;
        if (hints != null && hints.containsKey(EncodeHintType.CHARACTER_SET)) {
            encoding = String.valueOf(hints.get(EncodeHintType.CHARACTER_SET));
        }
        Mode mode = this.chooseMode(content, encoding);
        BitArray headerBits = new BitArray();
        if (mode == Mode.BYTE && !Intrinsics.areEqual((Object)DEFAULT_BYTE_MODE_ENCODING, (Object)encoding) && (eci = CharacterSetECI.getCharacterSetECIByName((String)encoding)) != null) {
            this.appendECI(eci, headerBits);
        }
        this.appendModeInfo(mode, headerBits);
        BitArray dataBits = new BitArray();
        this.appendBytes(content, mode, dataBits, encoding);
        int provisionalBitsNeeded = this.calculateBitsNeeded(mode, headerBits, dataBits, Version.getVersionForNumber((int)1));
        for (int versionNum = 1; versionNum < 41; ++versionNum) {
            Version version = Version.getVersionForNumber((int)versionNum);
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
            if (!this.willFit(provisionalBitsNeeded, version, ErrorCorrectionLevel.L)) continue;
            return version.getVersionNumber() * 4 + 17;
        }
        return 177;
    }

    private final boolean willFit(int numInputBits, Version version, ErrorCorrectionLevel ecLevel) {
        int totalInputBytes;
        Version.ECBlocks ecBlocks;
        int numEcBytes;
        int numBytes = version.getTotalCodewords();
        int numDataBytes = numBytes - (numEcBytes = (ecBlocks = version.getECBlocksForLevel(ecLevel)).getTotalECCodewords());
        return numDataBytes >= (totalInputBytes = (numInputBits + 7) / 8);
    }

    private final int calculateBitsNeeded(Mode mode, BitArray headerBits, BitArray dataBits, Version version) {
        return headerBits.getSize() + mode.getCharacterCountBits(version) + dataBits.getSize();
    }

    private final Mode chooseMode(String content, String encoding) {
        if (Intrinsics.areEqual((Object)"Shift_JIS", (Object)encoding) && this.isOnlyDoubleByteKanji(content)) {
            return Mode.KANJI;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        int n = content.length();
        for (int i = 0; i < n; ++i) {
            char element = content.charAt(i);
            boolean bl = '0' <= element ? element < ':' : false;
            if (bl) {
                hasNumeric = true;
                continue;
            }
            if (this.getAlphanumericCode(element) != -1) {
                hasAlphanumeric = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (hasAlphanumeric) {
            return Mode.ALPHANUMERIC;
        }
        return hasNumeric ? Mode.NUMERIC : Mode.BYTE;
    }

    private final boolean isOnlyDoubleByteKanji(String content) {
        byte[] byArray;
        try {
            Charset charset = Charset.forName("Shift_JIS");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray2 = content.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        catch (UnsupportedEncodingException ignored) {
            return false;
        }
        byte[] bytes = byArray;
        int length = bytes.length;
        if (length % 2 != 0) {
            return false;
        }
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            if (byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235) continue;
            return false;
        }
        return true;
    }

    private final int getAlphanumericCode(int code) {
        return code < ALPHANUMERIC_TABLE.length ? ALPHANUMERIC_TABLE[code] : -1;
    }

    public final void appendBytes(@NotNull String content, @NotNull Mode mode, @NotNull BitArray bits, @Nullable String encoding) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                this.appendNumericBytes(content, bits);
                break;
            }
            case 2: {
                this.appendAlphanumericBytes(content, bits);
                break;
            }
            case 3: {
                this.append8BitBytes(content, bits, encoding);
                break;
            }
            case 4: {
                this.appendKanjiBytes(content, bits);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + mode);
            }
        }
    }

    private final void appendNumericBytes(CharSequence content, BitArray bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    public final void append8BitBytes(@NotNull String content, @NotNull BitArray bits, @Nullable String encoding) throws WriterException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        try {
            String string = encoding;
            Intrinsics.checkNotNull((Object)string);
            Charset charset = Charset.forName(string);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray2 = content.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException((Throwable)uee);
        }
        for (byte b : byArray) {
            bits.appendBits((int)b, 8);
        }
    }

    public final void appendKanjiBytes(@NotNull String content, @NotNull BitArray bits) throws WriterException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        try {
            Charset charset = Charset.forName("Shift_JIS");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray2 = content.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException((Throwable)uee);
        }
        byte[] bytes = byArray;
        int length = bytes.length;
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            boolean bl = 33088 <= code ? code < 40957 : false;
            if (bl) {
                subtracted = code - 33088;
            } else {
                boolean bl2 = 57408 <= code ? code < 60352 : false;
                if (bl2) {
                    subtracted = code - 49472;
                }
            }
            if (subtracted == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
        }
    }

    public final void appendAlphanumericBytes(@NotNull CharSequence content, @NotNull BitArray bits) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = this.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new WriterException();
            }
            if (i + 1 < length) {
                int code2 = this.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new WriterException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    private final void appendECI(CharacterSetECI eci, BitArray bits) {
        bits.appendBits(Mode.ECI.getBits(), 4);
        bits.appendBits(eci.getValue(), 8);
    }

    private final void appendModeInfo(Mode mode, BitArray bits) {
        bits.appendBits(mode.getBits(), 4);
    }

    public static final /* synthetic */ String access$getBLACK$p() {
        return BLACK;
    }

    public static final /* synthetic */ String access$getWHITE$p() {
        return WHITE;
    }

    static {
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
        ALPHANUMERIC_TABLE = nArray;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.NUMERIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ALPHANUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.KANJI.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

