/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf;

import pro.parseq.vcf.exceptions.InvalidVcfFileException;
import pro.parseq.vcf.types.VcfFile;
import pro.parseq.vcf.utils.FaultTolerance;
import pro.parseq.vcf.utils.VcfParser;
import pro.parseq.vcf.utils.VcfReader;

/**
 * Main user-class for VCF parsing
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public class VcfExplorer {

	private VcfReader reader;
	private VcfParser parser;
	
	private boolean parsed = false;

	private VcfFile vcfData;

	public VcfExplorer(VcfReader reader, VcfParser parser) {
		this.reader = reader;
		this.parser = parser;
	}

	public void setReader(VcfReader reader) {
		this.reader = reader;
	}

	public void setParser(VcfParser parser) {
		this.parser = parser;
	}

	/**
	 * Retrieve VCF file content from VCF reader. 
	 * 
	 * Should not throw exception with repeated calls. 
	 * 
	 * @param mode FaultTolerance
	 * @throws InvalidVcfFileException
	 */
	public void parse(FaultTolerance mode) throws InvalidVcfFileException {
		if (!parsed) {
			vcfData = parser.parse(reader, mode);
			parsed = true;
		}
	}

	public VcfFile getVcfData() {
		return vcfData;
	}
}
