/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import pro.parseq.vcf.types.Metadata;
import pro.parseq.vcf.utils.VcfGrammar;

/**
 * Represents VCF FILTER meta-information field
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public class Filter extends Metadata {

	private String id;
	private String description;

	public Filter(String line) {

		super(line);

		Matcher idMatcher = VcfGrammar.filterIdPattern.matcher(line);
		Matcher descriptionMatcher = VcfGrammar.filterDescriptionPattern.matcher(line);
		if (idMatcher.find() && descriptionMatcher.find()) {
			id = line.substring(idMatcher.start(), idMatcher.end());
			description = line.substring(descriptionMatcher.start(), descriptionMatcher.end());
		}
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	protected Pattern getPattern() {
		return VcfGrammar.filterPattern;
	}

	public static final boolean isFilter(String line) {
		return VcfGrammar.filterPattern.matcher(line).matches();
	}
}
