/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf.fields.types;

import pro.parseq.vcf.fields.Format;

/**
 * Enumeration to represent all possible types for {@link Format} field
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public enum FormatFieldType {

	INTEGER("Integer"),
	FLOAT("Float"),
	CHARACTER("Character"),
	STRING("String");

	private String value;

	private FormatFieldType(String value) {
		this.value = value;
	}

	private String getValue() {
		return this.value;
	}

	@Override
	public String toString() {
		return this.getValue();
	}

	public static FormatFieldType getEnum(String value) {

		for (FormatFieldType enumValue: values()) {
			if (enumValue.getValue().equalsIgnoreCase(value)) {
				return enumValue;
			}
		}

		throw new IllegalArgumentException("InfoFieldValue: "
				+ "Unknown value [" + value + "]");
	}
}
