/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import pro.parseq.vcf.utils.VcfGrammar;

/**
 * Represents VCF meta-information line
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public class Metadata extends VcfLine {

	private static final Logger logger = LoggerFactory.getLogger(Metadata.class);

	private String key;
	private String value;

	public Metadata(String line) {

		super(line);
		if (!isValid()) {
			logger.error("Malformed meta-information line found: {}", line);
			return;
		}

		Matcher keyMatcher = VcfGrammar.metadataKeyPattern.matcher(line);
		Matcher valueMatcher = VcfGrammar.metadataValuePattern.matcher(line);
		if (keyMatcher.find() && valueMatcher.find()) {
			key = line.substring(keyMatcher.start(), keyMatcher.end());
			value = line.substring(valueMatcher.start(), valueMatcher.end());
		}
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}

	@Override
	protected Pattern getPattern() {
		return VcfGrammar.metadataPattern;
	}
}
