/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf.utils;

import pro.parseq.vcf.exceptions.InvalidVcfFileException;
import pro.parseq.vcf.types.VcfFile;

/**
 * Interface for parsing VCF files
 * 
 * @author Alexander Afanasyev <a href="mailto:aafanasyev@parseq.pro">aafanasyev@parseq.pro</a>
 */
public interface VcfParser {

	/**
	 * Parses input VCF file
	 * 
	 * @param reader VCF file reader
	 * @param mode Parsing mode (can be switched to fail fast or fail safe)
	 * @return {@link VcfFile} representing VCF file data
	 * @throws InvalidVcfFileException if input VCF file is malformed
	 */
	VcfFile parse(VcfReader reader, FaultTolerance mode) throws InvalidVcfFileException;
}
