/*******************************************************************************
 *     Copyright 2016-2017 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *******************************************************************************/
package pro.parseq.vcf.validators;

public interface LineValidator {

	/**
	 * Validate VCF file line
	 * 
	 * @param line Line to validate
	 * @return validation status
	 */
	boolean validate(String line);
	/**
	 * Get validation failure message
	 * 
	 * @return validation failure message
	 */
	String getFailureMessage();
}
