/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.Base64Kt;
import pbandk.internal.TimeUtilKt;
import pbandk.internal.Util;
import pbandk.wkt.Duration;
import pbandk.wkt.Timestamp;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lpbandk/internal/AbstractUtil;", "Lpbandk/internal/Util;", "<init>", "()V", "base64ToBytes", "", "str", "", "bytesToBase64", "bytes", "timestampToString", "ts", "Lpbandk/wkt/Timestamp;", "stringToTimestamp", "durationToString", "dur", "Lpbandk/wkt/Duration;", "stringToDuration", "pbandk-runtime_debug"})
public abstract class AbstractUtil
implements Util {
    @Override
    @NotNull
    public byte[] base64ToBytes(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        byte[] byArray = Base64Kt.decodeBase64ToArray(str);
        if (byArray == null) {
            throw new RuntimeException("Unable to base64-decode string: " + str);
        }
        return byArray;
    }

    @Override
    @NotNull
    public String bytesToBase64(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return StringsKt.decodeToString((byte[])Base64Kt.encodeBase64$default(bytes, null, 1, null));
    }

    @Override
    @NotNull
    public String timestampToString(@NotNull Timestamp ts) {
        Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
        return TimeUtilKt.formatTime(ts.getSeconds(), ts.getNanos());
    }

    @Override
    @NotNull
    public Timestamp stringToTimestamp(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return TimeUtilKt.parseTime(str);
    }

    @Override
    @NotNull
    public String durationToString(@NotNull Duration dur) {
        Intrinsics.checkNotNullParameter((Object)dur, (String)"dur");
        return TimeUtilKt.formatDuration(dur);
    }

    @Override
    @NotNull
    public Duration stringToDuration(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return TimeUtilKt.parseDuration(str);
    }
}

