/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.ListWithSize;
import pbandk.Message;
import pbandk.MessageMap;
import pbandk.UnknownField;
import pbandk.internal.binary.AbstractSizerKt;
import pbandk.internal.binary.BinaryMessageEncoderKt;
import pbandk.internal.binary.NumberExtensionsKt;
import pbandk.internal.binary.Sizer;
import pbandk.internal.binary.Tag;
import pbandk.internal.binary.Utf8LenKt;
import pbandk.internal.binary.WireType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001f\u0010\b\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0006\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\r2\u0006\u0010\u0006\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\r2\u0006\u0010\u0013\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u0014\u001a\u00020\u0005\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\t0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\t0\u00162\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00050\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00052\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*H\u0016J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*H\u0016J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*H\u0016J\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*H\u0016J\u0010\u00103\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001aH\u0016J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u000205H\u0016\u00a8\u00066"}, d2={"Lpbandk/internal/binary/AbstractSizer;", "Lpbandk/internal/binary/Sizer;", "<init>", "()V", "stringSize", "", "value", "", "enumSize", "T", "Lpbandk/Message$Enum;", "(Lpbandk/Message$Enum;)I", "lengthPrefixedMessageSize", "Lpbandk/Message;", "(Lpbandk/Message;)I", "delimitedMessageSize", "fieldNum", "(ILpbandk/Message;)I", "rawMessageSize", "message", "repeatedSize", "list", "", "valueType", "Lpbandk/FieldDescriptor$Type;", "packed", "", "packedRepeatedSize", "sizeFn", "Lkotlin/Function1;", "mapSize", "map", "", "entryCompanion", "Lpbandk/MessageMap$Entry$Companion;", "tagSize", "doubleSize", "", "floatSize", "", "int32Size", "int64Size", "", "uInt32Size", "uInt64Size", "sInt32Size", "sInt64Size", "fixed32Size", "fixed64Size", "sFixed32Size", "sFixed64Size", "boolSize", "bytesSize", "Lpbandk/ByteArr;", "pbandk-runtime_debug"})
@SourceDebugExtension(value={"SMAP\nAbstractSizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSizer.kt\npbandk/internal/binary/AbstractSizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public abstract class AbstractSizer
implements Sizer {
    @Override
    public int stringSize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int len = Utf8LenKt.utf8Len(value);
        return this.uInt32Size(len) + len;
    }

    @Override
    public <T extends Message.Enum> int enumSize(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.int32Size(value.getValue());
    }

    @Override
    public <T extends Message> int lengthPrefixedMessageSize(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.uInt32Size(value.getProtoSize()) + value.getProtoSize();
    }

    @Override
    public <T extends Message> int delimitedMessageSize(int fieldNum, @NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.tagSize(fieldNum) + value.getProtoSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Message> int rawMessageSize(@NotNull T message) {
        int n;
        Object object;
        Intrinsics.checkNotNullParameter(message, (String)"message");
        int protoSize = 0;
        for (FieldDescriptor<Message, ?> fd : message.getDescriptor().getFields()) {
            KProperty1<? extends Message, ?> kProperty1 = fd.getValue$pbandk_runtime_debug();
            Intrinsics.checkNotNull(kProperty1, (String)"null cannot be cast to non-null type kotlin.reflect.KProperty1<T of pbandk.internal.binary.AbstractSizer.rawMessageSize, *>");
            Object value = kProperty1.get(message);
            if (!BinaryMessageEncoderKt.shouldOutputValue(fd.getType$pbandk_runtime_debug(), value) || value == null) continue;
            object = fd.getType$pbandk_runtime_debug();
            protoSize += object instanceof FieldDescriptor.Type.Repeated ? this.tagSize(fd.getNumber$pbandk_runtime_debug()) * (((FieldDescriptor.Type.Repeated)fd.getType$pbandk_runtime_debug()).getPacked() ? 1 : ((List)value).size()) : (object instanceof FieldDescriptor.Type.Map ? this.tagSize(fd.getNumber$pbandk_runtime_debug()) * ((Map)value).size() : this.tagSize(fd.getNumber$pbandk_runtime_debug()));
            protoSize += AbstractSizerKt.protoSize(fd.getType$pbandk_runtime_debug(), fd.getNumber$pbandk_runtime_debug(), value);
        }
        Iterable iterable = message.getUnknownFields().values();
        int n2 = protoSize;
        int n3 = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            object = iterator.next();
            UnknownField unknownField = (UnknownField)object;
            n = n3;
            boolean bl = false;
            int n4 = it.getSize$pbandk_runtime_debug();
            n3 = n + n4;
        }
        n = n3;
        protoSize = n2 + n;
        return protoSize;
    }

    @Override
    public <T> int repeatedSize(int fieldNum, @NotNull List<? extends T> list, @NotNull FieldDescriptor.Type valueType, boolean packed) {
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Function1 sizeFn = arg_0 -> AbstractSizer.repeatedSize$lambda$1(valueType, fieldNum, arg_0);
        if (packed) {
            n = this.packedRepeatedSize(list, sizeFn);
        } else {
            Iterable iterable = list;
            int n2 = 0;
            for (Object t : iterable) {
                n2 += ((Number)sizeFn.invoke(t)).intValue();
            }
            n = n2;
        }
        return n;
    }

    @Override
    public <T> int packedRepeatedSize(@NotNull List<? extends T> list, @NotNull Function1<? super T, Integer> sizeFn) {
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(sizeFn, (String)"sizeFn");
        if (list instanceof ListWithSize && ((ListWithSize)list).getProtoSize() != null) {
            n = ((ListWithSize)list).getProtoSize() + this.uInt32Size(((ListWithSize)list).getProtoSize());
        } else {
            Iterable iterable = list;
            int n2 = 0;
            for (Object t : iterable) {
                n2 += ((Number)sizeFn.invoke(t)).intValue();
            }
            int it = n2;
            boolean bl = false;
            n = it + this.uInt32Size(it);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int mapSize(@NotNull Map<?, ?> map, @NotNull MessageMap.Entry.Companion<?, ?> entryCompanion) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(entryCompanion, (String)"entryCompanion");
        Iterable iterable = map.entrySet();
        int n = 0;
        for (Object t : iterable) {
            int n2;
            void entry;
            Map.Entry entry2 = (Map.Entry)t;
            int n3 = n;
            boolean bl = false;
            if (entry instanceof MessageMap.Entry) {
                n2 = ((MessageMap.Entry)entry).getProtoSize();
            } else {
                int n4;
                Object v;
                int n5;
                Object k;
                Object object;
                Object it = object = entry.getKey();
                boolean bl2 = false;
                Object object2 = k = BinaryMessageEncoderKt.shouldOutputValue(entryCompanion.getKeyType$pbandk_runtime_debug(), it) ? object : null;
                if (k != null) {
                    Object it2 = k;
                    boolean bl3 = false;
                    n5 = this.tagSize(1) + AbstractSizerKt.protoSize(entryCompanion.getKeyType$pbandk_runtime_debug(), 1, it2);
                } else {
                    n5 = 0;
                }
                int keySize = n5;
                Object it3 = v = entry.getValue();
                boolean bl4 = false;
                Object object3 = object = BinaryMessageEncoderKt.shouldOutputValue(entryCompanion.getValueType$pbandk_runtime_debug(), it3) ? v : null;
                if (object != null) {
                    Object it4 = object;
                    boolean bl5 = false;
                    n4 = this.tagSize(2) + AbstractSizerKt.protoSize(entryCompanion.getValueType$pbandk_runtime_debug(), 2, it4);
                } else {
                    n4 = 0;
                }
                int valueSize = n4;
                n2 = keySize + valueSize;
            }
            int size = n2;
            boolean bl6 = false;
            int n6 = this.uInt32Size(size) + size;
            n = n3 + n6;
        }
        return n;
    }

    @Override
    public int tagSize(int fieldNum) {
        return this.uInt32Size(Tag.constructor-impl(fieldNum, WireType.constructor-impl(0)));
    }

    @Override
    public int doubleSize(double value) {
        return 8;
    }

    @Override
    public int floatSize(float value) {
        return 4;
    }

    @Override
    public int int32Size(int value) {
        return value >= 0 ? this.uInt32Size(value) : 10;
    }

    @Override
    public int int64Size(long value) {
        return this.uInt64Size(value);
    }

    @Override
    public int uInt32Size(int value) {
        return (value & 0xFFFFFF80) == 0 ? 1 : ((value & 0xFFFFC000) == 0 ? 2 : ((value & 0xFFE00000) == 0 ? 3 : ((value & 0xF0000000) == 0 ? 4 : 5)));
    }

    @Override
    public int uInt64Size(long value) {
        long value2 = value;
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value2 < 0L) {
            return 10;
        }
        int n = 2;
        if ((value2 & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value2 >>>= 28;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value2 >>>= 14;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    @Override
    public int sInt32Size(int value) {
        return this.uInt32Size(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public int sInt64Size(long value) {
        return this.uInt64Size(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public int fixed32Size(int value) {
        return 4;
    }

    @Override
    public int fixed64Size(long value) {
        return 8;
    }

    @Override
    public int sFixed32Size(int value) {
        return 4;
    }

    @Override
    public int sFixed64Size(long value) {
        return 8;
    }

    @Override
    public int boolSize(boolean value) {
        return 1;
    }

    @Override
    public int bytesSize(@NotNull ByteArr value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.uInt32Size(value.getArray().length) + value.getArray().length;
    }

    private static final int repeatedSize$lambda$1(FieldDescriptor.Type $valueType, int $fieldNum, Object it) {
        return it != null ? AbstractSizerKt.protoSize($valueType, $fieldNum, it) : 0;
    }
}

