/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import pbandk.InvalidProtocolBufferException;
import pbandk.internal.binary.kotlin.WireReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB-\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0006\u0010$\u001a\u00020\u001cJ\b\u0010%\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000e\u00a8\u0006,"}, d2={"Lpbandk/internal/binary/InputStreamWireReader;", "Lpbandk/internal/binary/kotlin/WireReader;", "input", "Ljava/io/InputStream;", "sizeLimit", "", "bufferSize", "<init>", "(Ljava/io/InputStream;II)V", "firstByte", "", "(BLjava/io/InputStream;II)V", "value", "getSizeLimit", "()I", "setSizeLimit", "(I)V", "buffer", "", "bufferSizeAfterLimit", "pos", "totalBytesRetired", "currentLimit", "read", "length", "isAtEnd", "", "skipRawBytes", "", "readRawBytesSlowPath", "size", "ensureNoLeakedReferences", "readRawBytesSlowPathOneChunk", "readRawBytesSlowPathRemainingChunks", "", "sizeLeft", "resetSizeCounter", "recomputeBufferSizeAfterLimit", "totalBytesRead", "getTotalBytesRead", "tryRefillBuffer", "n", "refillBuffer", "skipRawBytesSlowPath", "pbandk-runtime_debug"})
@SourceDebugExtension(value={"SMAP\nInputStreamWireReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamWireReader.kt\npbandk/internal/binary/InputStreamWireReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
public final class InputStreamWireReader
implements WireReader {
    @NotNull
    private final InputStream input;
    private int sizeLimit;
    @NotNull
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int pos;
    private int totalBytesRetired;
    private final int currentLimit;

    public InputStreamWireReader(@NotNull InputStream input, int sizeLimit, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.sizeLimit = sizeLimit;
        this.buffer = new byte[bufferSize];
        this.currentLimit = Integer.MAX_VALUE;
    }

    public /* synthetic */ InputStreamWireReader(InputStream inputStream, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = 8192;
        }
        this(inputStream, n, n2);
    }

    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    public final void setSizeLimit(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Size limit cannot be negative: " + value;
            throw new IllegalArgumentException(string.toString());
        }
        this.sizeLimit = value;
    }

    public InputStreamWireReader(byte firstByte, @NotNull InputStream input, int sizeLimit, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(input, sizeLimit, bufferSize);
        this.buffer[0] = firstByte;
        this.bufferSize = 1;
    }

    public /* synthetic */ InputStreamWireReader(byte by, InputStream inputStream, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = 8192;
        }
        this(by, inputStream, n, n2);
    }

    @Override
    @NotNull
    public byte[] read(int length) {
        byte[] byArray;
        int tempPos = this.pos;
        boolean bl = 1 <= length ? length <= this.bufferSize - tempPos : false;
        if (bl) {
            this.pos = tempPos + length;
            byte[] byArray2 = this.buffer;
            int n = tempPos + length;
            byArray = ArraysKt.copyOfRange((byte[])byArray2, (int)tempPos, (int)n);
        } else {
            byArray = this.readRawBytesSlowPath(length, false);
        }
        return byArray;
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    @Override
    public void skipRawBytes(int length) {
        boolean bl = 0 <= length ? length <= this.bufferSize - this.pos : false;
        if (bl) {
            this.pos += length;
        } else {
            this.skipRawBytesSlowPath(length);
        }
    }

    private final byte[] readRawBytesSlowPath(int size, boolean ensureNoLeakedReferences) {
        byte[] result = this.readRawBytesSlowPathOneChunk(size);
        if (result != null) {
            return ensureNoLeakedReferences ? (byte[])result.clone() : result;
        }
        int originalBufferPos = this.pos;
        int bufferedBytes = this.bufferSize - this.pos;
        this.totalBytesRetired += this.bufferSize;
        this.pos = 0;
        this.bufferSize = 0;
        int sizeLeft = size - bufferedBytes;
        List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
        byte[] bytes = new byte[size];
        ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)originalBufferPos, (int)(originalBufferPos + bufferedBytes));
        int tempPos = bufferedBytes;
        for (byte[] chunk : chunks) {
            ArraysKt.copyInto$default((byte[])chunk, (byte[])bytes, (int)tempPos, (int)0, (int)0, (int)12, null);
            tempPos += chunk.length;
        }
        return bytes;
    }

    private final byte[] readRawBytesSlowPathOneChunk(int size) {
        if (size == 0) {
            return new byte[0];
        }
        if (size < 0) {
            throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime_debug();
        }
        int currentMessageSize = this.totalBytesRetired + this.pos + size;
        if (currentMessageSize - this.sizeLimit > 0) {
            throw InvalidProtocolBufferException.Companion.sizeLimitExceeded$pbandk_runtime_debug();
        }
        if (currentMessageSize > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
        }
        int bufferedBytes = this.bufferSize - this.pos;
        int sizeLeft = size - bufferedBytes;
        if (sizeLeft < 8192 || sizeLeft <= this.input.available()) {
            int n;
            byte[] bytes = new byte[size];
            ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)this.pos, (int)(this.pos + bufferedBytes));
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            for (int tempPos = bufferedBytes; tempPos < bytes.length; tempPos += n) {
                n = this.input.read(bytes, tempPos, size - tempPos);
                if (n == -1) {
                    throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
                }
                this.totalBytesRetired += n;
            }
            return bytes;
        }
        return null;
    }

    private final List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) {
        byte[] chunk;
        List chunks = new ArrayList();
        for (int sizeLeft2 = sizeLeft; sizeLeft2 > 0; sizeLeft2 -= chunk.length) {
            int n;
            chunk = new byte[RangesKt.coerceAtMost((int)sizeLeft2, (int)8192)];
            for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                n = this.input.read(chunk, tempPos, chunk.length - tempPos);
                if (n == -1) {
                    throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
                }
                this.totalBytesRetired += n;
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    public final void resetSizeCounter() {
        this.totalBytesRetired = -this.pos;
    }

    private final void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public final int getTotalBytesRead() {
        return this.totalBytesRetired + this.pos;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean tryRefillBuffer(int n) {
        if (!(this.pos + n > this.bufferSize)) {
            $i$a$-check-InputStreamWireReader$tryRefillBuffer$1 = false;
            $i$a$-check-InputStreamWireReader$tryRefillBuffer$1 = "refillBuffer() called when " + n + " bytes were already available in buffer";
            throw new IllegalStateException($i$a$-check-InputStreamWireReader$tryRefillBuffer$1.toString());
        }
        if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
            return false;
        }
        if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
            return false;
        }
        tempPos = this.pos;
        if (tempPos > 0) {
            if (this.bufferSize > tempPos) {
                ArraysKt.copyInto((byte[])this.buffer, (byte[])this.buffer, (int)0, (int)tempPos, (int)this.bufferSize);
            }
            this.totalBytesRetired += tempPos;
            this.bufferSize -= tempPos;
            this.pos = 0;
        }
        if ((bytesRead = this.input.read(this.buffer, this.bufferSize, RangesKt.coerceAtMost((int)(this.buffer.length - this.bufferSize), (int)(this.sizeLimit - this.totalBytesRetired - this.bufferSize)))) == -1) ** GOTO lbl-1000
        v0 = 1 <= bytesRead ? bytesRead <= this.buffer.length : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-check-InputStreamWireReader$tryRefillBuffer$2 = false;
            var4_7 = this.input.getClass() + "#read(ByteArray) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.";
            throw new IllegalStateException(var4_7.toString());
        }
        if (bytesRead > 0) {
            this.bufferSize += bytesRead;
            this.recomputeBufferSizeAfterLimit();
            return this.bufferSize >= n ? true : this.tryRefillBuffer(n);
        }
        return false;
    }

    private final void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                throw InvalidProtocolBufferException.Companion.sizeLimitExceeded$pbandk_runtime_debug();
            }
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void skipRawBytesSlowPath(int size) {
        int totalSkipped;
        if (size < 0) {
            throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime_debug();
        }
        if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
        }
        this.totalBytesRetired += this.pos;
        this.bufferSize = 0;
        this.pos = 0;
        try {
            long skipped;
            for (totalSkipped = this.bufferSize - this.pos; totalSkipped < size; totalSkipped += (int)skipped) {
                int toSkip = size - totalSkipped;
                skipped = this.input.skip(toSkip);
                if (!(0L <= skipped ? skipped <= (long)toSkip : false)) {
                    boolean bl = false;
                    String string = this.input.getClass() + "#skip returned invalid result: " + skipped + "\nThe InputStream implementation is buggy.";
                    throw new IllegalStateException(string.toString());
                }
                if (skipped != 0L) continue;
                break;
            }
        }
        finally {
            this.totalBytesRetired += totalSkipped;
            this.recomputeBufferSizeAfterLimit();
        }
        if (totalSkipped < size) {
            int tempPos = this.bufferSize - this.pos;
            this.pos = this.bufferSize;
            this.refillBuffer(1);
            while (size - tempPos > this.bufferSize) {
                tempPos += this.bufferSize;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
            }
            this.pos = size - tempPos;
        }
    }
}

