/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary.kotlin;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pbandk.InvalidProtocolBufferException;
import pbandk.internal.binary.kotlin.WireReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpbandk/internal/binary/kotlin/ByteArrayWireReader;", "Lpbandk/internal/binary/kotlin/WireReader;", "arr", "", "offset", "", "length", "<init>", "([BII)V", "([B)V", "limit", "pos", "read", "isAtEnd", "", "skipRawBytes", "", "pbandk-runtime_debug"})
public final class ByteArrayWireReader
implements WireReader {
    @NotNull
    private final byte[] arr;
    private final int limit;
    private int pos;

    public ByteArrayWireReader(@NotNull byte[] arr, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        this.arr = arr;
        this.limit = offset + length;
        this.pos = offset;
    }

    public ByteArrayWireReader(@NotNull byte[] arr) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        this(arr, 0, arr.length);
    }

    @Override
    @NotNull
    public byte[] read(int length) {
        byte[] byArray;
        boolean bl = 1 <= length ? length <= this.limit - this.pos : false;
        if (bl) {
            int tempPos = this.pos;
            this.pos += length;
            byte[] byArray2 = this.arr;
            int n = this.pos;
            byArray = ArraysKt.copyOfRange((byte[])byArray2, (int)tempPos, (int)n);
        } else {
            if (length < 0) {
                throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime_debug();
            }
            if (length == 0) {
                byArray = new byte[]{};
            } else {
                throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
            }
        }
        return byArray;
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.limit;
    }

    @Override
    public void skipRawBytes(int length) {
        boolean bl = 0 <= length ? length <= this.limit - this.pos : false;
        if (bl) {
            this.pos += length;
        } else {
            if (length < 0) {
                throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime_debug();
            }
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime_debug();
        }
    }
}

