/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary.kotlin;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.ListWithSize;
import pbandk.Message;
import pbandk.internal.binary.AbstractSizerKt;
import pbandk.internal.binary.BinaryWireEncoder;
import pbandk.internal.binary.NumberExtensionsKt;
import pbandk.internal.binary.Tag;
import pbandk.internal.binary.WireType;
import pbandk.internal.binary.kotlin.WireWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rH\u0016J$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0002J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0002J\u0018\u0010*\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\n\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u00105\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u0018\u00106\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u00107\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0002J\u0018\u00108\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u0018\u0010:\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020?H\u0016J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020EH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lpbandk/internal/binary/kotlin/KotlinBinaryWireEncoder;", "Lpbandk/internal/binary/BinaryWireEncoder;", "wireWriter", "Lpbandk/internal/binary/kotlin/WireWriter;", "<init>", "(Lpbandk/internal/binary/kotlin/WireWriter;)V", "writeValueNoTag", "", "type", "Lpbandk/FieldDescriptor$Type;", "value", "", "writeUInt32NoTag", "", "writeUInt32NoTag$pbandk_runtime_debug", "writeUInt64NoTag", "", "writeTag", "fieldNum", "wireType", "Lpbandk/internal/binary/WireType;", "writeTag-nHk__68", "(II)V", "writeRawBytes", "", "writeRawBytes-9N1wL9M", "(II[B)V", "writeLengthDelimitedHeader", "protoSize", "writeGroupStart", "writeGroupEnd", "writePackedRepeated", "list", "", "valueType", "writeInt32NoTag", "writeInt32", "writeInt64NoTag", "writeInt64", "writeUInt32", "writeUInt64", "writeSInt32NoTag", "writeSInt32", "writeSInt64NoTag", "writeSInt64", "writeBoolNoTag", "", "writeBool", "writeEnumNoTag", "Lpbandk/Message$Enum;", "writeEnum", "writeFixed32NoTag", "writeFixed32", "writeFixed64NoTag", "writeFixed64", "writeSFixed32NoTag", "writeSFixed32", "writeSFixed64NoTag", "writeSFixed64", "writeFloatNoTag", "", "writeFloat", "writeDoubleNoTag", "", "writeDouble", "writeStringNoTag", "", "writeString", "writeBytesNoTag", "Lpbandk/ByteArr;", "writeBytes", "pbandk-runtime_debug"})
@SourceDebugExtension(value={"SMAP\nKotlinBinaryWireEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBinaryWireEncoder.kt\npbandk/internal/binary/kotlin/KotlinBinaryWireEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n1#2:267\n1863#3,2:268\n*S KotlinDebug\n*F\n+ 1 KotlinBinaryWireEncoder.kt\npbandk/internal/binary/kotlin/KotlinBinaryWireEncoder\n*L\n122#1:268,2\n*E\n"})
public final class KotlinBinaryWireEncoder
implements BinaryWireEncoder {
    @NotNull
    private final WireWriter wireWriter;

    public KotlinBinaryWireEncoder(@NotNull WireWriter wireWriter) {
        Intrinsics.checkNotNullParameter((Object)wireWriter, (String)"wireWriter");
        this.wireWriter = wireWriter;
    }

    private final void writeValueNoTag(FieldDescriptor.Type type, Object value) {
        FieldDescriptor.Type type2 = type;
        if (type2 instanceof FieldDescriptor.Type.Primitive.Double) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
            this.writeDoubleNoTag((Double)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Float) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
            this.writeFloatNoTag(((Float)value).floatValue());
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int64) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            this.writeInt64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt64) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            this.writeUInt64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int32) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            this.writeInt32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed64) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            this.writeFixed64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed32) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            this.writeFixed32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bool) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.writeBoolNoTag((Boolean)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.String) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            this.writeStringNoTag((String)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bytes) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type pbandk.ByteArr");
            this.writeBytesNoTag((ByteArr)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt32) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            this.writeUInt32NoTag$pbandk_runtime_debug((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed32) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            this.writeSFixed32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed64) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            this.writeSFixed64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt32) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            this.writeSInt32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt64) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            this.writeSInt64NoTag((Long)value);
        } else {
            if (type2 instanceof FieldDescriptor.Type.Message) {
                throw new IllegalStateException("writeValueNoTag() should only be called for primitive types".toString());
            }
            if (type2 instanceof FieldDescriptor.Type.Enum) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type pbandk.Message.Enum");
                this.writeEnumNoTag((Message.Enum)value);
            } else {
                if (type2 instanceof FieldDescriptor.Type.Repeated) {
                    throw new IllegalStateException("writeValueNoTag() should only be called for primitive types".toString());
                }
                if (type2 instanceof FieldDescriptor.Type.Map) {
                    throw new IllegalStateException("writeValueNoTag() should only be called for primitive types".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void writeUInt32NoTag$pbandk_runtime_debug(int value) {
        byte[] buffer = new byte[10];
        int position = 0;
        int valueCur = value;
        while (position < 10) {
            if ((valueCur & 0xFFFFFF80) == 0) {
                buffer[position++] = (byte)valueCur;
                break;
            }
            buffer[position++] = (byte)(valueCur & 0x7F | 0x80);
            valueCur >>>= 7;
        }
        this.wireWriter.write(buffer, 0, position);
    }

    private final void writeUInt64NoTag(long value) {
        byte[] buffer = new byte[10];
        int position = 0;
        long valueCur = value;
        while (position < 10) {
            if ((valueCur & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer[position++] = (byte)valueCur;
                break;
            }
            buffer[position++] = (byte)(valueCur & 0x7FL | 0x80L);
            valueCur >>>= 7;
        }
        this.wireWriter.write(buffer, 0, position);
    }

    private final void writeTag-nHk__68(int fieldNum, int wireType) {
        this.writeUInt32NoTag$pbandk_runtime_debug(Tag.constructor-impl(fieldNum, wireType));
    }

    @Override
    public void writeRawBytes-9N1wL9M(int fieldNum, int wireType, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, wireType);
        this.wireWriter.write(value, 0, value.length);
    }

    @Override
    public void writeLengthDelimitedHeader(int fieldNum, int protoSize) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeUInt32NoTag$pbandk_runtime_debug(protoSize);
    }

    @Override
    public void writeGroupStart(int fieldNum) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getSTART_GROUP-K6X5YLY());
    }

    @Override
    public void writeGroupEnd(int fieldNum) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getEND_GROUP-K6X5YLY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writePackedRepeated(int fieldNum, @NotNull List<?> list, @NotNull FieldDescriptor.Type valueType) {
        Object object;
        Object object2;
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Object object3 = list instanceof ListWithSize ? (ListWithSize)list : null;
        if (object3 != null && (object3 = ((ListWithSize)object3).getProtoSize()) != null) {
            n = (Integer)object3;
        } else {
            object2 = list;
            int n2 = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = iterator.next();
                object = t;
                int n3 = n2;
                boolean bl = false;
                void v2 = it;
                if (v2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                int n4 = AbstractSizerKt.protoSize(valueType, fieldNum, v2);
                n2 = n3 + n4;
            }
            n = n2;
        }
        int listSize = n;
        this.writeLengthDelimitedHeader(fieldNum, listSize);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            Object element$iv;
            Object it = element$iv = object2.next();
            boolean bl = false;
            Object e = it;
            if (e == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            this.writeValueNoTag(valueType, e);
        }
    }

    private final void writeInt32NoTag(int value) {
        if (value >= 0) {
            this.writeUInt32NoTag$pbandk_runtime_debug(value);
        } else {
            this.writeUInt64NoTag(value);
        }
    }

    @Override
    public void writeInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeInt32NoTag(value);
    }

    private final void writeInt64NoTag(long value) {
        this.writeUInt64NoTag(value);
    }

    @Override
    public void writeInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeInt64NoTag(value);
    }

    @Override
    public void writeUInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeUInt32NoTag$pbandk_runtime_debug(value);
    }

    @Override
    public void writeUInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeUInt64NoTag(value);
    }

    private final void writeSInt32NoTag(int value) {
        this.writeUInt32NoTag$pbandk_runtime_debug(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public void writeSInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeSInt32NoTag(value);
    }

    private final void writeSInt64NoTag(long value) {
        this.writeUInt64NoTag(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public void writeSInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeSInt64NoTag(value);
    }

    private final void writeBoolNoTag(boolean value) {
        byte[] byArray = new byte[]{value ? (byte)1 : 0};
        this.wireWriter.write(byArray, 0, 1);
    }

    @Override
    public void writeBool(int fieldNum, boolean value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeBoolNoTag(value);
    }

    private final void writeEnumNoTag(Message.Enum value) {
        this.writeInt32NoTag(value.getValue());
    }

    @Override
    public void writeEnum(int fieldNum, @NotNull Message.Enum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeEnumNoTag(value);
    }

    private final void writeFixed32NoTag(int value) {
        int n = 0;
        byte[] byArray = new byte[4];
        WireWriter wireWriter = this.wireWriter;
        while (n < 4) {
            int n2 = n++;
            byArray[n2] = (byte)(value >> 8 * n2);
        }
        wireWriter.write(byArray, 0, 4);
    }

    @Override
    public void writeFixed32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeFixed32NoTag(value);
    }

    private final void writeFixed64NoTag(long value) {
        int n = 0;
        byte[] byArray = new byte[8];
        WireWriter wireWriter = this.wireWriter;
        while (n < 8) {
            int n2 = n++;
            byArray[n2] = (byte)(value >> 8 * n2);
        }
        wireWriter.write(byArray, 0, 8);
    }

    @Override
    public void writeFixed64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeFixed64NoTag(value);
    }

    private final void writeSFixed32NoTag(int value) {
        this.writeFixed32NoTag(value);
    }

    @Override
    public void writeSFixed32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeSFixed32NoTag(value);
    }

    private final void writeSFixed64NoTag(long value) {
        this.writeFixed64NoTag(value);
    }

    @Override
    public void writeSFixed64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeSFixed64NoTag(value);
    }

    private final void writeFloatNoTag(float value) {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value));
    }

    @Override
    public void writeFloat(int fieldNum, float value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeFloatNoTag(value);
    }

    private final void writeDoubleNoTag(double value) {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeDouble(int fieldNum, double value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeDoubleNoTag(value);
    }

    private final void writeStringNoTag(String value) {
        this.writeBytesNoTag(new ByteArr(StringsKt.encodeToByteArray((String)value)));
    }

    @Override
    public void writeString(int fieldNum, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeStringNoTag(value);
    }

    private final void writeBytesNoTag(ByteArr value) {
        this.writeUInt32NoTag$pbandk_runtime_debug(value.getArray().length);
        this.wireWriter.write(value.getArray(), 0, value.getArray().length);
    }

    @Override
    public void writeBytes(int fieldNum, @NotNull ByteArr value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeBytesNoTag(value);
    }
}

