/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.workingtime;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.LocalTimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.Pair;

class WorkingTimeSchedule {
    private final Map<DayOfWeek, Pair<SortedSet<LocalTimeInterval>, SortedSet<LocalTimeInterval>>> workingTimeByDayOfWeek = new EnumMap<DayOfWeek, Pair<SortedSet<LocalTimeInterval>, SortedSet<LocalTimeInterval>>>(DayOfWeek.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    WorkingTimeSchedule(Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeByDayOfWeek) {
        if (workingTimeByDayOfWeek.isEmpty()) {
            throw new InvalidArgumentException("At least one day of the week needs to have working time");
        }
        for (Map.Entry<DayOfWeek, Set<LocalTimeInterval>> dayOfWeekSetEntry : workingTimeByDayOfWeek.entrySet()) {
            SortedSet<LocalTimeInterval> intervalsAscending = this.sortedSetOf(dayOfWeekSetEntry.getValue(), null);
            LocalTime previousEnd = null;
            for (LocalTimeInterval current : intervalsAscending) {
                if (previousEnd != null && ((LocalTime)current.getBegin()).isBefore(previousEnd)) {
                    throw new IllegalArgumentException("Working time is overlapping for " + intervalsAscending);
                }
                previousEnd = (LocalTime)current.getEnd();
            }
            SortedSet<LocalTimeInterval> intervalsDescending = this.sortedSetOf(intervalsAscending, Comparator.reverseOrder());
            this.workingTimeByDayOfWeek.put(dayOfWeekSetEntry.getKey(), Pair.of(intervalsAscending, intervalsDescending));
        }
    }

    public boolean isWorkingDay(DayOfWeek dayOfWeek) {
        boolean bl;
        DayOfWeek dayOfWeek2 = dayOfWeek;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)dayOfWeek2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !this.workSlotsFor(dayOfWeek).isEmpty();
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public SortedSet<LocalTimeInterval> workSlotsFor(DayOfWeek dayOfWeek) {
        SortedSet<LocalTimeInterval> sortedSet;
        SortedSet<LocalTimeInterval> sortedSet2;
        DayOfWeek dayOfWeek2 = dayOfWeek;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)dayOfWeek2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SortedSet<LocalTimeInterval> sortedSet3 = sortedSet2 = (sortedSet = this.workSlotsForBySortOrder(dayOfWeek, Pair::getLeft));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, sortedSet2);
        return sortedSet;
    }

    public SortedSet<LocalTimeInterval> workSlotsForReversed(DayOfWeek dayOfWeek) {
        SortedSet<LocalTimeInterval> sortedSet;
        SortedSet<LocalTimeInterval> sortedSet2;
        DayOfWeek dayOfWeek2 = dayOfWeek;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)dayOfWeek2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SortedSet<LocalTimeInterval> sortedSet3 = sortedSet2 = (sortedSet = this.workSlotsForBySortOrder(dayOfWeek, Pair::getRight));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, sortedSet2);
        return sortedSet;
    }

    private SortedSet<LocalTimeInterval> workSlotsForBySortOrder(DayOfWeek dayOfWeek, Function<Pair<SortedSet<LocalTimeInterval>, SortedSet<LocalTimeInterval>>, SortedSet<LocalTimeInterval>> pairChooser) {
        SortedSet sortedSet;
        SortedSet<Object> sortedSet2;
        SortedSet<LocalTimeInterval> sortedSet3;
        DayOfWeek dayOfWeek2 = dayOfWeek;
        Function<Pair<SortedSet<LocalTimeInterval>, SortedSet<LocalTimeInterval>>, SortedSet<LocalTimeInterval>> function = pairChooser;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)dayOfWeek2, function);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Pair<SortedSet<LocalTimeInterval>, SortedSet<LocalTimeInterval>> bothIntervalSets = this.workingTimeByDayOfWeek.get(dayOfWeek);
        if (bothIntervalSets == null) {
            sortedSet3 = Collections.emptySortedSet();
            sortedSet2 = sortedSet3;
        } else {
            sortedSet3 = pairChooser.apply(bothIntervalSets);
            sortedSet2 = sortedSet3;
        }
        SortedSet sortedSet4 = sortedSet = sortedSet2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, sortedSet);
        return sortedSet3;
    }

    private SortedSet<LocalTimeInterval> sortedSetOf(Set<LocalTimeInterval> original, Comparator<LocalTimeInterval> comparator) {
        SortedSet<LocalTimeInterval> sortedSet;
        SortedSet<LocalTimeInterval> sortedSet2;
        Set<LocalTimeInterval> set = original;
        Comparator<LocalTimeInterval> comparator2 = comparator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, set, comparator2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TreeSet<LocalTimeInterval> sorted = new TreeSet<LocalTimeInterval>(comparator);
        sorted.addAll(original);
        SortedSet<LocalTimeInterval> sortedSet3 = sortedSet2 = (sortedSet = Collections.unmodifiableSortedSet(sorted));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, sortedSet2);
        return sortedSet;
    }

    static {
        WorkingTimeSchedule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingTimeSchedule.java", WorkingTimeSchedule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkingDay", "pro.taskana.common.internal.workingtime.WorkingTimeSchedule", "java.time.DayOfWeek", "dayOfWeek", "", "boolean"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workSlotsFor", "pro.taskana.common.internal.workingtime.WorkingTimeSchedule", "java.time.DayOfWeek", "dayOfWeek", "", "java.util.SortedSet"), 67);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workSlotsForReversed", "pro.taskana.common.internal.workingtime.WorkingTimeSchedule", "java.time.DayOfWeek", "dayOfWeek", "", "java.util.SortedSet"), 77);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "workSlotsForBySortOrder", "pro.taskana.common.internal.workingtime.WorkingTimeSchedule", "java.time.DayOfWeek:java.util.function.Function", "dayOfWeek:pairChooser", "", "java.util.SortedSet"), 81);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sortedSetOf", "pro.taskana.common.internal.workingtime.WorkingTimeSchedule", "java.util.Set:java.util.Comparator", "original:comparator", "", "java.util.SortedSet"), 95);
    }
}

