-- this script updates the TASKANA database schema from version 5.0.0 to version 5.1.0.
-- REORGS are only necessary for _some_ altering operations. See https://www.ibm.com/docs/en/db2/11.1?topic=statements-alter-table
SET SCHEMA %schemaName%;

INSERT INTO TASKANA_SCHEMA_VERSION (VERSION, CREATED) VALUES ('5.1.0', CURRENT_TIMESTAMP);

DROP INDEX IDX_TASK_POR_VALUE;

CREATE INDEX IDX_TASK_POR_VALUE ON TASK
   ("POR_VALUE" ASC, "WORKBASKET_ID" ASC)
   ALLOW REVERSE SCANS COLLECT SAMPLED DETAILED STATISTICS;
COMMIT WORK ;

CREATE INDEX IDX_TASK_LOWER_POR_VALUE ON TASK
   (LOWER("POR_VALUE") ASC, "WORKBASKET_ID" ASC)
   ALLOW REVERSE SCANS COLLECT SAMPLED DETAILED STATISTICS;
COMMIT WORK ;
