/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.jobs.Clock;
import pro.taskana.common.internal.logging.LoggingAspect;

public class RealClock
implements Clock {
    private final long initialStartDelay;
    private final long period;
    private final TimeUnit periodTimeUnit;
    private final List<Clock.ClockListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RealClock(long initialStartDelay, long period, TimeUnit periodTimeUnit) {
        this.initialStartDelay = initialStartDelay;
        this.period = period;
        this.periodTimeUnit = periodTimeUnit;
    }

    @Override
    public void register(Clock.ClockListener listener) {
        Clock.ClockListener clockListener = listener;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)clockListener);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.listeners.add(listener);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.timerService.scheduleAtFixedRate(this::reportTimeElapse, this.initialStartDelay, this.period, this.periodTimeUnit);
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    @Override
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.timerService.shutdown();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private void reportTimeElapse() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.listeners.forEach(Clock.ClockListener::timeElapsed);
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    static {
        RealClock.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RealClock.java", RealClock.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "register", "pro.taskana.common.internal.jobs.RealClock", "pro.taskana.common.internal.jobs.Clock$ClockListener", "listener", "", "void"), 26);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "pro.taskana.common.internal.jobs.RealClock", "", "", "", "void"), 31);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "pro.taskana.common.internal.jobs.RealClock", "", "", "", "void"), 37);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reportTimeElapse", "pro.taskana.common.internal.jobs.RealClock", "", "", "", "void"), 41);
    }
}

