/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationCategoryReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.MonitorQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl;

public class ClassificationCategoryReportBuilderImpl
extends TimeIntervalReportBuilderImpl<ClassificationCategoryReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements ClassificationCategoryReport.Builder {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public ClassificationCategoryReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        super(taskanaEngine, monitorMapper);
    }

    @Override
    public ClassificationCategoryReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        ClassificationCategoryReport classificationCategoryReport;
        ClassificationCategoryReport classificationCategoryReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationCategoryReport classificationCategoryReport3 = classificationCategoryReport2 = (classificationCategoryReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationCategoryReport2);
        return classificationCategoryReport;
    }

    @Override
    public ClassificationCategoryReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        ClassificationCategoryReport classificationCategoryReport;
        ClassificationCategoryReport classificationCategoryReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationCategoryReport report = new ClassificationCategoryReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfCategories(Instant.now(), timestamp, this);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            ClassificationCategoryReport classificationCategoryReport3 = report;
            classificationCategoryReport2 = classificationCategoryReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ClassificationCategoryReport classificationCategoryReport4 = classificationCategoryReport = classificationCategoryReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationCategoryReport);
        return classificationCategoryReport2;
    }

    @Override
    protected ClassificationCategoryReport.Builder _this() {
        ClassificationCategoryReportBuilderImpl classificationCategoryReportBuilderImpl;
        ClassificationCategoryReportBuilderImpl classificationCategoryReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationCategoryReportBuilderImpl classificationCategoryReportBuilderImpl3 = classificationCategoryReportBuilderImpl2 = (classificationCategoryReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationCategoryReportBuilderImpl2);
        return classificationCategoryReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "CLASSIFICATION_CATEGORY";
        String string3 = string = "CLASSIFICATION_CATEGORY";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    static {
        ClassificationCategoryReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationCategoryReportBuilderImpl.java", ClassificationCategoryReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.ClassificationCategoryReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.ClassificationCategoryReport"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.ClassificationCategoryReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.ClassificationCategoryReport"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "pro.taskana.monitor.internal.reports.ClassificationCategoryReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.ClassificationCategoryReport$Builder"), 53);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "pro.taskana.monitor.internal.reports.ClassificationCategoryReportBuilderImpl", "", "", "", "java.lang.String"), 58);
    }
}

