/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.history.internal;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.SpiLoader;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;

public final class HistoryEventManager {
    private static final Logger LOGGER;
    private final List<TaskanaHistory> taskanaHistories = SpiLoader.load(TaskanaHistory.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        HistoryEventManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(HistoryEventManager.class);
    }

    public HistoryEventManager(TaskanaEngine taskanaEngine) {
        for (TaskanaHistory history : this.taskanaHistories) {
            history.initialize(taskanaEngine);
            LOGGER.info("Registered history provider: {}", (Object)history.getClass().getName());
        }
        if (this.taskanaHistories.isEmpty()) {
            LOGGER.info("No TaskanaHistory provider found. Running without History.");
        }
    }

    public boolean isEnabled() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !this.taskanaHistories.isEmpty();
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public void createEvent(TaskHistoryEvent event) {
        TaskHistoryEvent taskHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.taskanaHistories.forEach(CheckedConsumer.wrap(historyProvider -> historyProvider.create(event)));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void createEvent(WorkbasketHistoryEvent event) {
        WorkbasketHistoryEvent workbasketHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.taskanaHistories.forEach(CheckedConsumer.wrap(historyProvider -> historyProvider.create(event)));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void createEvent(ClassificationHistoryEvent event) {
        ClassificationHistoryEvent classificationHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)classificationHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        }
        this.taskanaHistories.forEach(CheckedConsumer.wrap(historyProvider -> historyProvider.create(event)));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void deleteEvents(List<String> taskIds) {
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending taskIds to history service providers: {}", taskIds);
        }
        this.taskanaHistories.forEach(CheckedConsumer.wrap(historyProvider -> historyProvider.deleteHistoryEventsByTaskIds(taskIds)));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HistoryEventManager.java", HistoryEventManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnabled", "pro.taskana.spi.history.internal.HistoryEventManager", "", "", "", "boolean"), 31);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 35);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 43);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEvent", "pro.taskana.spi.history.internal.HistoryEventManager", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 51);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteEvents", "pro.taskana.spi.history.internal.HistoryEventManager", "java.util.List", "taskIds", "", "void"), 60);
    }
}

