/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.exceptions.ObjectReferencePersistenceException;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.internal.ObjectReferenceMapper;
import pro.taskana.task.internal.models.ObjectReferenceImpl;
import pro.taskana.task.internal.models.TaskImpl;

public class ObjectReferenceHandler {
    private static final Logger LOGGER;
    private final ObjectReferenceMapper objectReferenceMapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        ObjectReferenceHandler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ObjectReferenceHandler.class);
    }

    ObjectReferenceHandler(ObjectReferenceMapper objectReferenceMapper) {
        this.objectReferenceMapper = objectReferenceMapper;
    }

    void insertNewSecondaryObjectReferencesOnTaskCreation(TaskImpl task) throws ObjectReferencePersistenceException, InvalidArgumentException {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ObjectReference> objectReferences = task.getSecondaryObjectReferences();
        if (objectReferences != null) {
            for (ObjectReference objectReference : objectReferences) {
                ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)objectReference;
                this.initObjectReference(objectReferenceImpl, task);
                ObjectReferenceImpl.validate(objectReferenceImpl, "ObjectReference", "Task");
                try {
                    this.objectReferenceMapper.insert(objectReferenceImpl);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("TaskService.createTask() for TaskId={} INSERTED an object reference={}.", (Object)task.getId(), (Object)objectReference);
                }
                catch (PersistenceException e) {
                    throw new ObjectReferencePersistenceException(objectReference.getId(), task.getId(), e);
                }
            }
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    void insertAndDeleteObjectReferencesOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ObjectReferencePersistenceException, InvalidArgumentException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ObjectReference> newObjectReferences = newTaskImpl.getSecondaryObjectReferences().stream().filter(Objects::nonNull).collect(Collectors.toList());
        newTaskImpl.setSecondaryObjectReferences(newObjectReferences);
        for (ObjectReference objectReference : newObjectReferences) {
            ObjectReferenceImpl.validate(objectReference, "Object Reference", "Task");
            this.initObjectReference((ObjectReferenceImpl)objectReference, newTaskImpl);
        }
        this.deleteRemovedObjectReferencesOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.insertNewObjectReferencesOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.updateModifiedObjectReferencesOnTaskUpdate(newTaskImpl, oldTaskImpl);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void insertNewObjectReferencesOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ObjectReferencePersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set oldObjectReferencesIds = oldTaskImpl.getSecondaryObjectReferences().stream().map(ObjectReference::getId).collect(Collectors.toSet());
        List newObjectReferences = newTaskImpl.getSecondaryObjectReferences().stream().filter(Predicate.not(o -> oldObjectReferencesIds.contains(o.getId()))).collect(Collectors.toList());
        for (ObjectReference objectReference : newObjectReferences) {
            this.insertNewObjectReferenceOnTaskUpdate(newTaskImpl, objectReference);
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void updateModifiedObjectReferencesOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ObjectReference> newObjectReferences = newTaskImpl.getSecondaryObjectReferences();
        List<ObjectReference> oldObjectReferences = oldTaskImpl.getSecondaryObjectReferences();
        if (newObjectReferences != null && !newObjectReferences.isEmpty() && oldObjectReferences != null && !oldObjectReferences.isEmpty()) {
            Map oldObjectReferencesMap = oldObjectReferences.stream().collect(Collectors.toMap(ObjectReference::getId, Function.identity()));
            newObjectReferences.forEach(o -> {
                if (oldObjectReferencesMap.containsKey(o.getId()) && !o.equals(oldObjectReferencesMap.get(o.getId()))) {
                    this.objectReferenceMapper.update((ObjectReferenceImpl)o);
                }
            });
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void deleteRemovedObjectReferencesOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        List<ObjectReference> oldObjectReferences;
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ObjectReference> newObjectReferences = newTaskImpl.getSecondaryObjectReferences();
        List<Object> newObjectReferencesIds = new ArrayList();
        if (newObjectReferences != null && !newObjectReferences.isEmpty()) {
            newObjectReferencesIds = newObjectReferences.stream().map(ObjectReference::getId).collect(Collectors.toList());
        }
        if ((oldObjectReferences = oldTaskImpl.getSecondaryObjectReferences()) != null && !oldObjectReferences.isEmpty()) {
            ArrayList newObjRefIds = newObjectReferencesIds;
            oldObjectReferences.forEach(o -> {
                if (!newObjRefIds.contains(o.getId())) {
                    this.objectReferenceMapper.delete(o.getId());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("TaskService.updateTask() for TaskId={} DELETED an ObjectReference={}.", (Object)newTaskImpl.getId(), o);
                    }
                }
            });
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void insertNewObjectReferenceOnTaskUpdate(TaskImpl newTaskImpl, ObjectReference objectReference) throws ObjectReferencePersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        ObjectReference objectReference2 = objectReference;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)taskImpl, (Object)objectReference2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)objectReference;
        try {
            this.objectReferenceMapper.insert(objectReferenceImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an ObjectReference={}.", (Object)newTaskImpl.getId(), (Object)objectReferenceImpl);
            }
        }
        catch (PersistenceException e) {
            throw new ObjectReferencePersistenceException(objectReferenceImpl.getId(), newTaskImpl.getId(), e);
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void initObjectReference(ObjectReferenceImpl objectReference, Task newTask) {
        ObjectReferenceImpl objectReferenceImpl = objectReference;
        Task task = newTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)objectReferenceImpl, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (objectReference.getTaskId() == null) {
            objectReference.setTaskId(newTask.getId());
        }
        if (objectReference.getId() == null) {
            objectReference.setId(IdGenerator.generateWithPrefix((String)"ORI"));
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ObjectReferenceHandler.java", ObjectReferenceHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertNewSecondaryObjectReferencesOnTaskCreation", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl", "task", "pro.taskana.task.api.exceptions.ObjectReferencePersistenceException:pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertAndDeleteObjectReferencesOnTaskUpdate", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.ObjectReferencePersistenceException:pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 56);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertNewObjectReferencesOnTaskUpdate", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.ObjectReferencePersistenceException", "void"), 74);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateModifiedObjectReferencesOnTaskUpdate", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 91);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteRemovedObjectReferencesOnTaskUpdate", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 112);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertNewObjectReferenceOnTaskUpdate", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.api.models.ObjectReference", "newTaskImpl:objectReference", "pro.taskana.task.api.exceptions.ObjectReferencePersistenceException", "void"), 139);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initObjectReference", "pro.taskana.task.internal.ObjectReferenceHandler", "pro.taskana.task.internal.models.ObjectReferenceImpl:pro.taskana.task.api.models.Task", "objectReference:newTask", "", "void"), 157);
    }
}

