/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs;

import java.time.Duration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaConfiguration;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker;

public class TaskUpdatePriorityJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private final int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        TaskUpdatePriorityJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskUpdatePriorityJob.class);
    }

    public TaskUpdatePriorityJob(TaskanaEngine taskanaEngine) {
        this(taskanaEngine, null, null);
    }

    public TaskUpdatePriorityJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob, true);
        this.batchSize = taskanaEngine.getConfiguration().getTaskUpdatePriorityJobBatchSize();
        this.runEvery = taskanaEngine.getConfiguration().getTaskUpdatePriorityJobRunEvery();
        this.firstRun = taskanaEngine.getConfiguration().getTaskUpdatePriorityJobFirstRun();
    }

    @Override
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskUpdatePriorityWorker worker = new TaskUpdatePriorityWorker(this.taskanaEngineImpl);
        LOGGER.info("Running job to calculate all non finished task priorities");
        try {
            CollectionUtil.partitionBasedOnSize(worker.getAllRelevantTaskIds(), (int)this.getBatchSize()).forEach(worker::executeBatch);
            LOGGER.info("Job to update priority of tasks has finished.");
        }
        catch (Exception e) {
            throw new SystemException("Error while processing TaskUpdatePriorityJob.", (Throwable)e);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public static Duration getLockExpirationPeriod(TaskanaConfiguration taskanaConfiguration) {
        Duration duration;
        Duration duration2;
        TaskanaConfiguration taskanaConfiguration2 = taskanaConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = taskanaConfiguration.getTaskUpdatePriorityJobLockExpirationPeriod());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public int getBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.batchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = TaskUpdatePriorityJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String toString() {
        return "TaskUpdatePriorityJob [firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", taskanaEngineImpl=" + this.taskanaEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + ", batchSize=" + this.batchSize + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskUpdatePriorityJob.java", TaskUpdatePriorityJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLockExpirationPeriod", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "pro.taskana.TaskanaConfiguration", "taskanaConfiguration", "", "java.time.Duration"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBatchSize", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "int"), 54);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "java.lang.String"), 59);
    }
}

