/*
 * Decompiled with CFR 0.152.
 */
package pro.vdshb.dbcleaner;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pro.vdshb.dbcleaner.postgresutil.PostgresConstraint;
import pro.vdshb.dbcleaner.postgresutil.PostgresTrigger;
import pro.vdshb.dbcleaner.postgresutil.PostgresUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0018\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0019\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001a\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpro/vdshb/dbcleaner/PostgresqlDatabaseCleaner;", "", "()V", "dataSource", "Ljavax/sql/DataSource;", "cleanPostgresDb", "", "schemaToClean", "", "onlyTables", "", "excludeTables", "cleanTable", "connection", "Ljava/sql/Connection;", "tableName", "cleanTables", "tablesToClean", "restoreConstraints", "constraints", "Lpro/vdshb/dbcleaner/postgresutil/PostgresConstraint;", "restoreTriggers", "triggers", "Lpro/vdshb/dbcleaner/postgresutil/PostgresTrigger;", "setConstraintsDeferred", "setTriggersDeferred", "throwExceptionIfIncorrectTableInList", "allTables", "junit-db-cleaner-extension"})
public final class PostgresqlDatabaseCleaner {
    private static final DataSource dataSource;
    public static final PostgresqlDatabaseCleaner INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void cleanPostgresDb(@NotNull String schemaToClean, @NotNull List<String> onlyTables, @NotNull List<String> excludeTables) {
        Intrinsics.checkParameterIsNotNull((Object)schemaToClean, (String)"schemaToClean");
        Intrinsics.checkParameterIsNotNull(onlyTables, (String)"onlyTables");
        Intrinsics.checkParameterIsNotNull(excludeTables, (String)"excludeTables");
        AutoCloseable autoCloseable = dataSource.getConnection();
        boolean bl = false;
        Throwable throwable = null;
        try {
            void $this$filterTo$iv$iv;
            Connection connection = (Connection)autoCloseable;
            boolean bl2 = false;
            Connection connection2 = connection;
            Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"connection");
            List<String> allTables = PostgresUtilKt.findAllTables(schemaToClean, connection2);
            List tablesToClean = null;
            Collection collection = onlyTables;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                tablesToClean = onlyTables;
                INSTANCE.throwExceptionIfIncorrectTableInList(onlyTables, allTables);
            } else {
                tablesToClean = allTables;
            }
            Iterable $this$filter$iv = tablesToClean;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(!excludeTables.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tablesToClean = (List)destination$iv$iv;
            INSTANCE.cleanTables(schemaToClean, tablesToClean, connection);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void cleanPostgresDb$default(PostgresqlDatabaseCleaner postgresqlDatabaseCleaner, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "public";
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        postgresqlDatabaseCleaner.cleanPostgresDb(string, list, list2);
    }

    private final void throwExceptionIfIncorrectTableInList(List<String> tablesToClean, List<String> allTables) {
        Iterable $this$forEach$iv = tablesToClean;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (allTables.contains(it)) continue;
            throw (Throwable)new IllegalArgumentException("There is no table '" + it + "' in database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanTables(String schemaToClean, List<String> tablesToClean, Connection connection) {
        connection.setAutoCommit(false);
        try {
            List<PostgresConstraint> constraints = PostgresUtilKt.findAllTableConstraints(schemaToClean, tablesToClean, connection);
            this.setConstraintsDeferred(constraints, connection);
            List<PostgresTrigger> triggers = PostgresUtilKt.findAllConstraintTriggers(constraints, connection);
            this.setTriggersDeferred(triggers, connection);
            Iterable $this$forEach$iv = tablesToClean;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                INSTANCE.cleanTable(connection, it);
            }
            this.restoreConstraints(constraints, connection);
            this.restoreTriggers(triggers, connection);
            connection.commit();
        }
        catch (Exception ex) {
            connection.rollback();
            throw (Throwable)ex;
        }
        finally {
            connection.setAutoCommit(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setConstraintsDeferred(List<PostgresConstraint> constraints, Connection connection) {
        void $this$mapTo$iv$iv;
        if (constraints.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = constraints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostgresConstraint postgresConstraint = (PostgresConstraint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getOid();
            collection.add(l);
        }
        String constraintsOids = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        connection.createStatement().execute("UPDATE pg_catalog.pg_constraint SET condeferrable = true, condeferred = true\n                                 WHERE oid IN (" + constraintsOids + ')');
    }

    /*
     * WARNING - void declaration
     */
    private final void setTriggersDeferred(List<PostgresTrigger> triggers, Connection connection) {
        void $this$mapTo$iv$iv;
        if (triggers.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = triggers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostgresTrigger postgresTrigger = (PostgresTrigger)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getOid();
            collection.add(l);
        }
        String triggerOids = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        connection.createStatement().execute("UPDATE pg_catalog.pg_trigger SET tgdeferrable = true, tginitdeferred = true\n                                 WHERE oid IN (" + triggerOids + ')');
    }

    private final void restoreConstraints(List<PostgresConstraint> constraints, Connection connection) {
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE pg_catalog.pg_constraint SET condeferrable = ?, condeferred = ? WHERE oid = ?");
        Iterable $this$forEach$iv = constraints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostgresConstraint constraint = (PostgresConstraint)element$iv;
            boolean bl = false;
            preparedStatement.setBoolean(1, constraint.getCondeferrable());
            preparedStatement.setBoolean(2, constraint.getCondeferred());
            preparedStatement.setLong(3, constraint.getOid());
            preparedStatement.execute();
        }
    }

    private final void restoreTriggers(List<PostgresTrigger> triggers, Connection connection) {
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE pg_catalog.pg_trigger SET tgdeferrable = ?, tginitdeferred = ? WHERE oid = ?");
        Iterable $this$forEach$iv = triggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostgresTrigger trigger = (PostgresTrigger)element$iv;
            boolean bl = false;
            preparedStatement.setBoolean(1, trigger.getTgdeferrable());
            preparedStatement.setBoolean(2, trigger.getTginitdeferred());
            preparedStatement.setLong(3, trigger.getOid());
            preparedStatement.execute();
        }
    }

    private final void cleanTable(Connection connection, String tableName) {
        String cleanQuery = "DELETE FROM " + tableName;
        connection.createStatement().execute(cleanQuery);
    }

    private PostgresqlDatabaseCleaner() {
    }

    static {
        PostgresqlDatabaseCleaner postgresqlDatabaseCleaner;
        INSTANCE = postgresqlDatabaseCleaner = new PostgresqlDatabaseCleaner();
        InputStream dbCleanerPropertiesStream = postgresqlDatabaseCleaner.getClass().getClassLoader().getResourceAsStream("db-cleaner.properties");
        Properties properties = new Properties();
        properties.load(dbCleanerPropertiesStream);
        HikariConfig config = new HikariConfig();
        Object object = properties.get("url");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        config.setJdbcUrl((String)object);
        Object object2 = properties.get("driver");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        config.setDriverClassName((String)object2);
        Object object3 = properties.get("username");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        config.setUsername((String)object3);
        Object object4 = properties.get("password");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        config.setPassword((String)object4);
        dataSource = (DataSource)new HikariDataSource(config);
        dbCleanerPropertiesStream.close();
    }
}

