package pro.verron.officestamper.core;

import org.docx4j.wml.*;

/**
 * This class is an abstract implementation of the {@link DocumentWalker} interface.
 * It implements all methods of the interface and does nothing in the individual methods.
 * This makes it easier to implement a custom {@link DocumentWalker} because the implementor
 * only has to implement the methods that are of interest.
 *
 * @author Joseph Verron
 * @author Tom Hombergs
 * @version 2.0.1
 * @since 1.0.0
 */
public abstract class BaseDocumentWalker extends DocumentWalker {

    /**
     * Creates a new document walker that walks through the given document.
     *
     * @param contentAccessor the document to walk through.
     */
    protected BaseDocumentWalker(ContentAccessor contentAccessor) {
        super(contentAccessor);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onParagraph(P paragraph) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onRun(R run) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onTable(Tbl table) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onTableCell(Tc tableCell) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onTableRow(Tr tableRow) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onCommentRangeStart(CommentRangeStart commentRangeStart) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onCommentRangeEnd(CommentRangeEnd commentRangeEnd) {

    }

    /** {@inheritDoc} */
    @Override
    protected void onCommentReference(R.CommentReference commentReference) {

    }
}
