/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import pub.carzy.export_file.exce.ExportNotSupportedException;
import pub.carzy.export_file.file_export.MetaInfo;
import pub.carzy.export_file.file_export.MetaInfoField;
import pub.carzy.export_file.file_export.actuator.ExportActuator;
import pub.carzy.export_file.file_export.actuator.ExportActuatorConfig;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.actuator.FileWriter;
import pub.carzy.export_file.file_export.entity.ExportTitle;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;
import pub.carzy.export_file.template.FileWriteFactory;
import pub.carzy.export_file.util.ObjectUtils;

public abstract class AbstractExportActuator
implements ExportActuator {
    protected ExportActuatorParam actuatorParam;
    protected Object data;
    protected ProceedingJoinPoint point;
    protected static final Map<Class<?>, MetaInfo> infoMap = new HashMap();
    protected FileWriter writer;
    private ExportActuatorConfig config;

    public AbstractExportActuator(Object data, ProceedingJoinPoint point, ExportActuatorParam actuatorParam, ExportActuatorConfig config) {
        this.data = data;
        this.point = point;
        this.actuatorParam = actuatorParam;
        this.config = config;
        this.findWriter();
    }

    @Override
    public Object getObject() {
        return this.writer.getFile();
    }

    protected void findWriter() {
        for (FileWriteFactory factory : this.config.getFactories()) {
            if (!factory.match(this.actuatorParam.getParam().getFileType())) continue;
            this.writer = factory.createWriter(this.actuatorParam);
            return;
        }
        throw new ExportNotSupportedException();
    }

    @Override
    public List<ExportTitle> getTitles() {
        return this.actuatorParam.getParam().getTitles() == null || this.actuatorParam.getParam().getTitles().size() <= 0 ? this.doGetTitles() : this.actuatorParam.getParam().getTitles();
    }

    protected List<ExportTitle> doGetTitles() {
        return new ArrayList<ExportTitle>();
    }

    @Override
    public void close() throws IOException {
        this.doClose();
    }

    protected void doClose() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void createFile() {
        this.writer.createFile();
    }

    @Override
    public void writeTitles(List<ExportTitle> titles) {
        List<String> title = this.transformTitles(titles);
        this.writer.writeLine(title, this.actuatorParam.getParam().getTitleStyle());
    }

    protected List<String> transformTitles(List<ExportTitle> titles) {
        ArrayList<String> list = new ArrayList<String>(titles.size());
        for (ExportTitle exportTitle : titles) {
            list.add(exportTitle.getTitle());
        }
        return list;
    }

    @Override
    public void writeContent() {
        List values = this.transformContent();
        if (values != null && values.size() > 0) {
            this.writer.writeMany(values, this.actuatorParam.getParam().getValueStyle());
        }
    }

    protected List<List<Object>> transformContent() {
        if (this.data == null) {
            return null;
        }
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        ArrayList<Object> line = new ArrayList<Object>();
        list.add(line);
        this.parseAndPutObjectValue(line, this.data);
        return list;
    }

    protected void parseAndPutObjectValue(List<Object> line, Object obj) {
        if (obj == null) {
            return;
        }
        MetaInfo metaInfo = this.getMetaInfo(obj.getClass());
        List<MetaInfoField> fields = metaInfo.getFields();
        block0: for (ExportTitle title : this.actuatorParam.getParam().getTitles()) {
            for (MetaInfoField field : fields) {
                if (!field.getName().equals(title.getName())) continue;
                Object value = field.getCallback().getValue(obj);
                line.add(this.transformValue(title, value));
                continue block0;
            }
        }
    }

    protected Object transformValue(ExportTitle title, Object value) {
        ExportValueFormat format = title.getConvertor();
        if (format == null) {
            return value;
        }
        for (ExportFileValueConvertor convertor : this.config.getConvertors()) {
            if (!convertor.match(format)) continue;
            Object val = convertor.formatValue(format, value);
            return val == null ? "" : val;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaInfo getMetaInfo(Class<?> aClass) {
        if (infoMap.get(aClass) == null) {
            Map<Class<?>, MetaInfo> map = infoMap;
            synchronized (map) {
                if (infoMap.get(aClass) == null) {
                    MetaInfo info = new MetaInfo();
                    info.setFields(new ArrayList<MetaInfoField>());
                    HashSet<Field> fieldSet = new HashSet<Field>();
                    ObjectUtils.getAllFields(aClass, fieldSet);
                    for (Field field : fieldSet) {
                        MetaInfoField infoField = new MetaInfoField();
                        infoField.setName(field.getName());
                        try {
                            Method method = aClass.getMethod("get" + ObjectUtils.uppercaseFirst(field.getName()), new Class[0]);
                            infoField.setCallback(target -> {
                                try {
                                    return method.invoke(target, new Object[0]);
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    return null;
                                }
                            });
                        }
                        catch (NoSuchMethodException e) {
                            infoField.setCallback(target -> {
                                field.setAccessible(true);
                                try {
                                    return field.get(target);
                                }
                                catch (IllegalAccessException ex) {
                                    return null;
                                }
                            });
                        }
                        info.getFields().add(infoField);
                    }
                    infoMap.put(aClass, info);
                }
            }
        }
        return infoMap.get(aClass);
    }
}

