/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.writers;

import com.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.actuator.writers.AbstractFileWriter;

public class CsvFileWriter
extends AbstractFileWriter {
    private CSVWriter csvWriter;

    public CsvFileWriter(ExportActuatorParam param) {
        super(param);
    }

    @Override
    public <T> void writeLine(List<T> line, Map<String, Object> configs) {
        if (line.size() > 0) {
            List<String> list = line.stream().map(Object::toString).collect(Collectors.toList());
            this.csvWriter.writeNext(list.toArray(new String[0]));
        }
    }

    @Override
    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    @Override
    protected void createdFile() throws IOException {
        super.createdFile();
        this.csvWriter = new CSVWriter((Writer)new FileWriter(this.file));
    }

    @Override
    protected String getFilename() {
        return this.param.getPrefix() + (this.param.getParam().getFilename().endsWith(".csv") ? this.param.getParam().getFilename() : this.param.getParam().getFilename() + ".csv");
    }

    @Override
    public void close() throws IOException {
        if (this.csvWriter != null) {
            this.csvWriter.flush();
            this.csvWriter.close();
        }
    }
}

