/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.spring_bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import pub.carzy.export_file.spring_bean.AopExportFileConfig;

public class AopExpressionBeanPostProcess
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private ApplicationContext context;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            String property = this.context.getEnvironment().getProperty("web.export.aop-expression");
            if (property == null || "".equals(property)) {
                return;
            }
            Method aroundMethod = AopExportFileConfig.class.getDeclaredMethod("webPointcut", new Class[0]);
            Pointcut pointcut = aroundMethod.getAnnotation(Pointcut.class);
            if (Objects.isNull(pointcut)) {
                return;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(pointcut);
            Field declaredField = invocationHandler.getClass().getDeclaredField("memberValues");
            declaredField.setAccessible(true);
            Map valMap = (Map)declaredField.get(invocationHandler);
            valMap.put("value", property);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

