/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.spring_bean;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.actuator.FileWriter;
import pub.carzy.export_file.file_export.actuator.writers.CsvFileWriter;
import pub.carzy.export_file.file_export.actuator.writers.ExcelFileWriter;
import pub.carzy.export_file.file_export.actuator.writers.TxtFileWriter;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;
import pub.carzy.export_file.spring_bean.AopExpressionBeanPostProcess;
import pub.carzy.export_file.template.DefaultExportAopCallback;
import pub.carzy.export_file.template.ExportAopCallback;
import pub.carzy.export_file.template.ExportConvertorMerger;
import pub.carzy.export_file.template.FileWriteFactory;

@Import(value={AopExpressionBeanPostProcess.class})
public class ExportBeans {
    @Bean
    @ConditionalOnMissingBean(value={ExportAopCallback.class})
    ExportAopCallback callback() {
        return new DefaultExportAopCallback();
    }

    @Bean
    @ConditionalOnMissingBean(value={ExportConvertorMerger.class})
    ExportConvertorMerger exportActuatorMerger() {
        return new ExportConvertorMerger();
    }

    @Bean
    FileWriteFactory csvFileWriteFactory() {
        return new FileWriteFactory(){

            public int getOrder() {
                return 0;
            }

            @Override
            public boolean match(Integer type) {
                return type == 1;
            }

            @Override
            public FileWriter createWriter(ExportActuatorParam param) {
                return new CsvFileWriter(param);
            }
        };
    }

    @Bean
    FileWriteFactory txtFileWriteFactory() {
        return new FileWriteFactory(){

            public int getOrder() {
                return 0;
            }

            @Override
            public boolean match(Integer type) {
                return type == 3;
            }

            @Override
            public FileWriter createWriter(ExportActuatorParam param) {
                return new TxtFileWriter(param);
            }
        };
    }

    @Bean
    FileWriteFactory excelFileWriteFactory() {
        return new FileWriteFactory(){

            public int getOrder() {
                return 0;
            }

            @Override
            public boolean match(Integer type) {
                return type == 2;
            }

            @Override
            public FileWriter createWriter(ExportActuatorParam param) {
                return new ExcelFileWriter(param);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={ExportFileValueConvertor.class})
    ExportFileValueConvertor defaultExportFileValueConvertor() {
        return new ExportFileValueConvertor(){

            @Override
            public boolean match(ExportValueFormat convertor) {
                return false;
            }

            @Override
            public Object formatValue(ExportValueFormat convertor, Object value) {
                return null;
            }
        };
    }
}

