/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.template;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.util.StringUtils;
import pub.codex.common.CodexException;
import pub.codex.common.db.entity.ColumnEntity;
import pub.codex.common.db.entity.TableEntity;
import pub.codex.core.template.stream.template.BaseTableCodexTemplate;

public abstract class TableCodexTemplate
extends BaseTableCodexTemplate {
    protected TableEntity tableEntity = new TableEntity();
    protected ZipOutputStream zip;

    public abstract void coding();

    public void buildTemplate(Map<String, String> table, List<Map<String, String>> columns, String tablePrefix, ZipOutputStream zip) {
        this.tableEntity.setTableName(table.get("tableName"));
        this.tableEntity.setComments(table.get("tableComment"));
        String className = this.tableToJava(this.tableEntity.getTableName(), tablePrefix);
        this.tableEntity.setClassName(className);
        this.tableEntity.setClassname(StringUtils.uncapitalize((String)className));
        ArrayList<ColumnEntity> columsList = new ArrayList<ColumnEntity>();
        for (Map<String, String> column : columns) {
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColumnName(column.get("columnName"));
            columnEntity.setDataType(column.get("dataType"));
            columnEntity.setComments(column.get("columnComment"));
            columnEntity.setExtra(column.get("extra"));
            String attrName = this.columnToJava(columnEntity.getColumnName());
            columnEntity.setAttrName(attrName);
            columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = this.getConfig().getString(columnEntity.getDataType(), "unknowType");
            columnEntity.setAttrType(attrType);
            if ("PRI".equalsIgnoreCase(column.get("columnKey")) && this.tableEntity.getPk() == null) {
                this.tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        this.tableEntity.setColumns(columsList);
        this.zip = zip;
        this.coding();
    }

    protected void buildTemplate(String templateName, Map<String, Object> map, String filepath) {
        Template template = this.getTemplate(templateName);
        VelocityContext context = new VelocityContext(map);
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        try {
            this.zip.putNextEntry(new ZipEntry(filepath));
            IOUtils.write((String)sw.toString(), (OutputStream)this.zip, (String)"UTF-8");
            IOUtils.closeQuietly((Writer)sw);
            this.zip.closeEntry();
        }
        catch (IOException e) {
            throw new CodexException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + this.tableEntity.getClassName(), (Throwable)e);
        }
    }
}

