/*
 * Decompiled with CFR 0.152.
 */
package pub.codex.core.template.stream.template;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pub.codex.common.db.jdbc.TableDao;
import pub.codex.core.template.stream.template.TableCodexTemplate;

@Service
public class TableCodexTemplateStream {
    @Autowired
    private List<TableCodexTemplate> tableCodexTemplateList;
    @Autowired
    private TableDao tableDao;

    public byte[] doTemplate(String tableName, String tablePrefix) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        Map<String, String> table = this.getTable(tableName);
        List<Map<String, String>> columns = this.getColumns(tableName);
        this.tableCodexTemplateList.stream().forEach(tableCodexTemplate -> tableCodexTemplate.buildTemplate(table, columns, tablePrefix, zip));
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    private Map<String, String> getTable(String tableName) {
        return this.tableDao.queryTable(tableName);
    }

    private List<Map<String, String>> getColumns(String tableName) {
        return this.tableDao.queryColumns(tableName);
    }
}

