import org.javacord.api.DiscordApi;
import org.javacord.api.DiscordApiBuilder;
import pw.mihou.velen.interfaces.Velen;
import pw.mihou.velen.interfaces.hybrid.objects.VelenOption;
import java.net.URISyntaxException;


public class Test {

    public static void main(String[] ar) throws URISyntaxException {
        Velen velen = Velen.ofDefaults();
        velen.addHandler("hybrid.hi", (event, responder, user, args) -> {
            if (args.withName("user").isPresent()) {
                responder.setContent("Hello " + args.withName("user").get().requestUser().get().join().getName());
            } else {
                responder.setContent("Hello " + user.getName());
            }

            responder.respond();
        });

        velen.addHandler("hybrid.number", (event, responder, user, args) -> args.withName("number").flatMap(VelenOption::asInteger)
                .ifPresent(integer -> responder.setContent("I say number " + integer).respond()));

        velen.addHandler("hybrid.ping", (event, responder, user, args) -> args.withName("response").flatMap(VelenOption::asString)
                .ifPresent(s -> responder.setContent(s).respond()));

        velen.addHandler("hybrid.say", (event, responder, user, args) -> args.getManyWithName("text")
                .ifPresent(s -> responder.setContent(s).respond()));

        velen.addHandler("hybrid.regex", (event, responder, user, args) -> {
            if (args.withName("url").isPresent()) {
                responder.setContent(args.withName("url").get().asString().get()).respond();
            } else {
                // This actually only works on message commands.
                responder.setContent("The URL was rejected!").respond();
            }
        });

        velen.addHandler("hybrid.scream", (event, responder, user, args) -> args.withName("scream")
                .ifPresent(s -> responder.setContent(s.asString().get()).respond()));

        velen.addHybridAfterware("hybrid.log_command",
                (event, arguments, command) -> System.out.println(event.getUser().getId() + " used the command : " + command.getName()));
        velen.addMessageAfterware("message.log_command",
                (event, command, options) -> System.out.println(event.getMessageAuthor().getId() + " used the command : " + command.getName()));
        velen.addSlashAfterware("slash.log_command",
                (event, command) -> System.out.println(event.getSlashCommandInteraction().getUser().getId() +
                        " used the command : " + command.getName()));


        velen.loadFrom("examples/hybrid");

        DiscordApi api = new DiscordApiBuilder()
                .setToken(System.getenv("token"))
                .setAllIntents()
                .addListener(velen)
                .login()
                .join();

        // velen.createIndexFile(true).index(true, api).join();
        System.out.println("You can now run the bot.");
    }

}
