/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.quilt.cl.CatchData;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.graph.BinaryConnector;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;
import org.quilt.graph.Visitor;

public class BytecodeCollector
implements Visitor {
    private ControlFlowGraph graph = null;
    private Map startHandles = null;
    private Map endHandles = null;
    private Map gotoFixMeUps = null;
    private InstructionList ilist = null;

    public void discoverGraph(Directed g) {
        this.graph = (ControlFlowGraph)g;
        this.ilist = this.graph.getInstructionList();
        this.startHandles = this.graph.getStartHandles();
        this.endHandles = this.graph.getEndHandles();
        this.gotoFixMeUps = this.graph.getGotoFixMeUps();
    }

    public void discoverVertex(Vertex vtx) {
        if (vtx == null) {
            throw new IllegalArgumentException("null vertex");
        }
        if (!(vtx instanceof Entry) && !(vtx instanceof Exit)) {
            CodeVertex v = (CodeVertex)vtx;
            InstructionList vIList = v.getInstructionList();
            InstructionHandle vStart = null;
            if (vIList.size() == 0) {
                vIList = new InstructionList((Instruction)new NOP());
            }
            if ((vStart = this.ilist.append(vIList)) == null) {
                System.out.println("discoverVertex INTERNAL ERROR: vertex " + v + " has null position in bytecode\n");
            }
            if (vStart == null) {
                System.out.println("    ** vStart is null **");
            }
            this.startHandles.put(v, vStart);
            Instruction inst = v.getConnInst();
            if (inst != null) {
                if (inst instanceof GotoInstruction) {
                    BranchHandle bh = this.ilist.append((BranchInstruction)((GotoInstruction)inst));
                    this.endHandles.put(v, bh);
                } else if (inst instanceof IfInstruction) {
                    BranchHandle bh = this.ilist.append((BranchInstruction)((IfInstruction)inst));
                    this.endHandles.put(v, bh);
                } else if (inst instanceof JsrInstruction) {
                    BranchHandle bh = this.ilist.append((BranchInstruction)((JsrInstruction)inst));
                    this.endHandles.put(v, bh);
                } else if (inst instanceof Select) {
                    BranchHandle bh = this.ilist.append((BranchInstruction)((Select)inst));
                    this.endHandles.put(v, bh);
                } else if (inst instanceof ExceptionThrower || inst instanceof ReturnInstruction || inst instanceof RET || inst instanceof InvokeInstruction) {
                    InstructionHandle ih = this.ilist.append(inst);
                    this.endHandles.put(v, ih);
                } else {
                    this.ilist.append(inst);
                }
            }
        }
    }

    public void discoverEdge(Edge e) {
    }

    public void finishEdge(Edge e) {
    }

    private CodeVertex getEffectiveTarget(Edge e) {
        Vertex target = e.getTarget();
        while (target != null && (target instanceof Entry || target instanceof Exit)) {
            target = target.getTarget();
        }
        return (CodeVertex)target;
    }

    public void finishVertex(Vertex vtx) {
        CodeVertex v;
        Instruction inst;
        if (vtx instanceof CodeVertex && (inst = (v = (CodeVertex)vtx).getConnInst()) != null) {
            if (inst instanceof GotoInstruction) {
                CodeVertex effTarget = this.getEffectiveTarget(((BinaryConnector)v.getConnector()).getOtherEdge());
                InstructionHandle target = (InstructionHandle)this.startHandles.get(effTarget);
                this.gotoFixMeUps.put(v, effTarget);
            } else if (inst instanceof IfInstruction) {
                Edge workingEdge = ((BinaryConnector)v.getConnector()).getOtherEdge();
                InstructionHandle target = (InstructionHandle)this.startHandles.get(this.getEffectiveTarget(workingEdge));
                BranchHandle bh = (BranchHandle)this.endHandles.get(v);
                bh.setTarget(target);
            } else if (inst instanceof JsrInstruction) {
                InstructionHandle target = (InstructionHandle)this.startHandles.get(this.getEffectiveTarget(v.getEdge()));
                BranchHandle bh = (BranchHandle)this.endHandles.get(v);
                bh.setTarget(target);
            } else if (inst instanceof Select) {
                InstructionHandle target = (InstructionHandle)this.startHandles.get(this.getEffectiveTarget(v.getEdge()));
                BranchHandle bh = (BranchHandle)this.endHandles.get(v);
                bh.setTarget(target);
                ComplexConnector conn = (ComplexConnector)v.getConnector();
                int edgeCount = conn.size();
                InstructionHandle[] targets = new InstructionHandle[edgeCount];
                int i = 0;
                while (i < edgeCount) {
                    target = (InstructionHandle)this.startHandles.get(this.getEffectiveTarget(conn.getEdge(i)));
                    if (target == null) {
                        System.out.println("BytecodeCollector.finishVertex " + v + " INTERNAL ERROR: \n" + "    " + inst + " has null target " + i);
                    }
                    ((Select)bh.getInstruction()).setTarget(i, target);
                    ++i;
                }
            }
        }
    }

    private void dumpIList(String where) {
        System.out.println("BytecodeCollector." + where + " instruction list:");
        int i = 0;
        InstructionHandle ih = this.ilist.getStart();
        while (ih != null) {
            System.out.println("  " + i++ + "  " + ih.getInstruction());
            ih = ih.getNext();
        }
    }

    public void finishGraph(Directed g) {
    }

    public InstructionList getInstructionList() {
        Iterator k = this.gotoFixMeUps.keySet().iterator();
        while (k.hasNext()) {
            CodeVertex v = (CodeVertex)k.next();
            BranchHandle bh = (BranchHandle)this.endHandles.get(v);
            InstructionHandle target = (InstructionHandle)this.startHandles.get(this.gotoFixMeUps.get(v));
            bh.setTarget(target);
        }
        this.ilist.update();
        return this.ilist;
    }

    public CodeExceptionGen[] getCEGs(CatchData[] cd) {
        CodeExceptionGen[] ceg;
        if (cd == null) {
            ceg = new CodeExceptionGen[]{};
        } else {
            ceg = new CodeExceptionGen[cd.length];
            int i = 0;
            while (i < cd.length) {
                InstructionHandle start = (InstructionHandle)this.startHandles.get(cd[i].tryStart);
                InstructionHandle end = (InstructionHandle)this.startHandles.get(cd[i].tryEnd);
                InstructionHandle handler = (InstructionHandle)this.startHandles.get(cd[i].handlerPC);
                if (start == null || end == null || handler == null) {
                    System.out.println("BytecodeCollector.getCEGs: INTERNAL ERROR - null handler\n    CatchData[" + i + "] start: " + cd[i].tryStart + " end: " + cd[i].tryEnd + " handler at: " + cd[i].handlerPC);
                }
                ceg[i] = new CodeExceptionGen(start, end, handler, cd[i].exception);
                ++i;
            }
        }
        return ceg;
    }
}

