/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.Hashtable;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.quilt.cl.ClassXformer;
import org.quilt.cl.MethodTransformer;

public class ClassTransformer {
    private Hashtable classHash = new Hashtable();
    private List cxf;
    private List mxf;
    private List gxf;
    private MethodTransformer xformer;
    boolean aborted_ = false;

    public ClassTransformer(List cxf, List mxf, List gxf) {
        this.cxf = cxf;
        this.mxf = mxf;
        this.gxf = gxf;
        this.xformer = new MethodTransformer(mxf, gxf);
    }

    public Hashtable getClassHash() {
        return this.classHash;
    }

    private void zapClassXformer(ClassXformer cxf, Exception e) {
        System.err.println("WARNING: exception in " + cxf.getName() + ": transformation will not be applied");
        e.printStackTrace();
        cxf = null;
    }

    public JavaClass xform(JavaClass jc) {
        if (jc == null || !jc.isClass()) {
            throw new IllegalArgumentException("null or corrupt JavaClass");
        }
        ClassGen clazz = new ClassGen(jc);
        ClassTransformer.makePublic(clazz);
        this.aborted_ = false;
        ClassXformer[] xf = new ClassXformer[this.cxf.size()];
        int i = 0;
        while (i < xf.length) {
            try {
                xf[i] = (ClassXformer)this.cxf.get(i).getClass().newInstance();
                xf[i].setClassTransformer(this);
            }
            catch (IllegalAccessException e) {
                this.zapClassXformer(xf[i], e);
            }
            catch (InstantiationException e) {
                this.zapClassXformer(xf[i], e);
            }
            if (xf[i] != null && !this.aborted_) {
                xf[i].preMethods(clazz);
            }
            ++i;
        }
        if (this.mxf.size() > 0 || this.gxf.size() > 0 && !this.aborted_) {
            Method[] methods = clazz.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                MethodGen result;
                String methodName = methods[i2].getName();
                if (methods[i2].getCode() != null && !methodName.startsWith("q$$q") && (result = this.xformer.xform(clazz, methods[i2])) != null) {
                    clazz.replaceMethod(methods[i2], result.getMethod());
                    InstructionList ilist = result.getInstructionList();
                    ilist.dispose();
                    result = null;
                }
                ++i2;
            }
        }
        int i3 = xf.length - 1;
        while (i3 >= 0) {
            if (xf[i3] != null && !this.aborted_) {
                xf[i3].postMethods(clazz);
            }
            --i3;
        }
        if (clazz == null || this.aborted_) {
            System.out.println("ClassTransformer WARNING could not transform class");
            return jc;
        }
        return clazz.getJavaClass();
    }

    protected static void makePublic(ClassGen cg) {
        int flags = cg.getAccessFlags();
        flags &= 0xFFFFFFF9;
        cg.setAccessFlags(flags |= 1);
        if (!cg.isPublic()) {
            System.out.println("WARNING: makePublic for " + cg.getClassName() + " failed");
        }
    }

    public void abort() {
        this.aborted_ = true;
    }
}

