/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.graph.BinaryConnector;
import org.quilt.graph.Edge;
import org.quilt.graph.UnaryConnector;
import org.quilt.graph.Vertex;

public class CodeVertex
extends Vertex {
    protected int pos = -1;
    protected InstructionList ilist = new InstructionList();
    protected int startLine_ = -1;
    protected int endLine_ = -1;
    protected Instruction connInst_ = null;

    public CodeVertex(ControlFlowGraph g) {
        super(g);
    }

    public CodeVertex(ControlFlowGraph g, int position) {
        super(g);
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        this.pos = position;
    }

    public CodeVertex(ControlFlowGraph g, String l) {
        super(g);
        this.pos = -1;
        this.label_ = l;
    }

    public Instruction getConnInst() {
        return this.connInst_;
    }

    public void setConnInst(Instruction i) {
        if (i == null) {
            throw new IllegalArgumentException("null instruction");
        }
        this.connInst_ = i;
    }

    public InstructionList getInstructionList() {
        return this.ilist;
    }

    public int getStartLine() {
        return this.startLine_;
    }

    public void setStartLine(int n) {
        this.startLine_ = n;
    }

    public int getEndLine() {
        return this.endLine_;
    }

    public void setEndLine(int n) {
        this.endLine_ = n;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPos(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        this.pos = position;
    }

    public void moveGoto(CodeVertex target) {
        if (target == null) {
            throw new IllegalArgumentException("null target vertex");
        }
        BinaryConnector biConnector = (BinaryConnector)this.getConnector();
        Edge flowEdge = biConnector.getEdge();
        Edge otherEdge = biConnector.getOtherEdge();
        if (otherEdge.getTarget() != target) {
            throw new IllegalArgumentException("not target of otherEdge");
        }
        if (!(this.connInst_ instanceof GotoInstruction)) {
            throw new IllegalArgumentException("connecting instruction not goto");
        }
        UnaryConnector uConnector = (UnaryConnector)target.getConnector();
        Edge uEdge = uConnector.getEdge();
        Vertex tgtTarget = uEdge.getTarget();
        uEdge.setSource(this);
        uEdge.setTarget(target);
        this.setConnector(uConnector);
        flowEdge.setSource(target);
        otherEdge.setSource(target);
        otherEdge.setTarget(tgtTarget);
        target.setConnector(biConnector);
        target.setConnInst(this.connInst_);
        this.connInst_ = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("Code ").append(super.toString()).append(" pos ").append(this.pos);
        if (this.startLine_ > -1) {
            sb.append(" line ").append(this.startLine_);
        }
        if (this.endLine_ > -1) {
            sb.append("/").append(this.endLine_);
        }
        return sb.toString();
    }

    public String toString(boolean b) {
        StringBuffer sb = new StringBuffer().append(this.toString());
        if (b) {
            if (this.label_ != null) {
                sb.append("\n    label ").append(this.label_);
            }
            sb.append("\n    ilist: ");
            InstructionHandle ih = this.ilist.getStart();
            while (ih != null) {
                sb.append(ih.getInstruction());
            }
        }
        return sb.toString();
    }
}

