/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.cl.GraphXformer;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Connector;
import org.quilt.graph.Directed;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;
import org.quilt.graph.Visitor;
import org.quilt.graph.Walker;

public class GraphTalker
implements GraphXformer,
Visitor {
    private static String name = null;

    public void discoverGraph(Directed graph) {
        ControlFlowGraph g = (ControlFlowGraph)graph;
        System.out.println("--------------------------------------");
        if (g.getParent() != null) {
            System.out.print("SUB");
        }
        System.out.println("GRAPH with " + g.size() + " vertices");
    }

    public void finishGraph(Directed graph) {
        System.out.println("--------------------------------------");
    }

    public void discoverVertex(Vertex v) {
        Connector conn = v.getConnector();
        StringBuffer sb = new StringBuffer().append("VERTEX ").append(v);
        if (v instanceof Entry) {
            ControlFlowGraph parent = (ControlFlowGraph)v.getGraph().getParent();
            sb.append("  graph ").append(v.getGraph().getIndex()).append(" whose parent is graph ");
            if (parent == null) {
                sb.append("<null>\n");
            } else {
                sb.append(parent.getIndex()).append("\n");
            }
            if (conn instanceof ComplexConnector) {
                int k = conn.size();
                sb.append("    HANDLERS\n");
                int i = 0;
                while (i < k) {
                    sb.append("        -> ").append(((ComplexConnector)conn).getEdge(i).getTarget()).append("\n");
                    ++i;
                }
            }
        } else if (v instanceof Exit) {
            sb.append("  EXIT\n");
        } else {
            CodeVertex cv = (CodeVertex)v;
            sb.append("\n    instructions:\n");
            InstructionList ilist = cv.getInstructionList();
            Instruction[] inst = ilist.getInstructions();
            if (inst.length == 0) {
                sb.append("        none\n");
            }
            int i = 0;
            while (i < inst.length) {
                sb.append("    ").append(inst[i]).append("\n");
                ++i;
            }
            Instruction connInst = cv.getConnInst();
            if (connInst == null) {
                sb.append("    NO CONNECTING INSTRUCTION (flows through)\n");
            } else {
                sb.append("    CONNECTING INST: ").append(connInst).append("\n");
            }
        }
        System.out.print(sb.toString());
    }

    public void finishVertex(Vertex v) {
    }

    public void discoverEdge(Edge e) {
        System.out.println("  EDGE " + e.getSource() + " -> " + e.getTarget());
    }

    public void finishEdge(Edge e) {
    }

    public void xform(ClassGen cg, MethodGen method, ControlFlowGraph cfg) {
        Walker walker = new Walker();
        walker.visit(cfg, this);
    }

    public static String getName() {
        return name;
    }

    public static void setName(String s) {
        name = s;
    }
}

