/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.List;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.quilt.cl.BytecodeCollector;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.cl.GraphXformer;
import org.quilt.cl.SortedBlocks;
import org.quilt.cl.TryStacks;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;
import org.quilt.graph.Walker;

public class GraphTransformer {
    private List gxf;
    private TryStacks ts = null;
    private CodeExceptionGen[] handlers;
    private CodeExceptionGen[] ceg = null;
    private InstructionList ilist = null;

    public GraphTransformer(List gxf) {
        this.gxf = gxf;
    }

    private void zapGraphXformer(GraphXformer gxf, Exception e) {
        System.err.println("WARNING: exception in : transformation will not be applied");
        e.printStackTrace();
        gxf = null;
    }

    public InstructionList xform(ClassGen clazz, MethodGen method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        ControlFlowGraph graph = this.makeGraph(clazz, method);
        GraphXformer[] xf = new GraphXformer[this.gxf.size()];
        int i = 0;
        while (i < this.gxf.size()) {
            try {
                xf[i] = (GraphXformer)this.gxf.get(i).getClass().newInstance();
            }
            catch (IllegalAccessException e) {
                this.zapGraphXformer(xf[i], e);
            }
            catch (InstantiationException e) {
                this.zapGraphXformer(xf[i], e);
            }
            if (xf[i] != null && graph != null) {
                xf[i].xform(clazz, method, graph);
            }
            ++i;
        }
        if (graph == null) {
            return null;
        }
        BytecodeCollector bc = this.collapseGraph(graph);
        this.ilist = bc.getInstructionList();
        if (this.ilist == null) {
            return null;
        }
        if (this.ts == null) {
            this.ceg = null;
        } else {
            this.ceg = bc.getCEGs(this.ts.getCatchData());
            if (this.ceg.length != this.handlers.length) {
                System.out.println("GraphTransformer.xform WARNING - PROBABLE INTERNAL ERROR:\n   method had " + this.handlers.length + " exception handlers, but after graph transformation " + this.ceg.length);
            }
        }
        return this.ilist;
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        if (this.ilist != null && this.ceg != null) {
            return this.ceg;
        }
        return new CodeExceptionGen[0];
    }

    protected final ControlFlowGraph makeGraph(ClassGen clazz, MethodGen method) {
        ControlFlowGraph cfg;
        SortedBlocks blox = new SortedBlocks();
        this.handlers = method.getExceptionHandlers();
        ControlFlowGraph currGraph = cfg = new ControlFlowGraph();
        Edge e = cfg.getEntry().getEdge();
        this.ts = null;
        boolean startBlock = false;
        CodeVertex currV = null;
        LineNumberTable lineTab = method.getLineNumberTable(clazz.getConstantPool());
        if (this.handlers.length > 0) {
            this.ts = new TryStacks(this.handlers, blox, cfg);
        }
        currV = blox.exists(0) ? blox.get(0) : blox.find(0, currGraph, e);
        if (lineTab != null) {
            currV.setStartLine(lineTab.getSourceLine(0));
        }
        e = currV.getEdge();
        currGraph = (ControlFlowGraph)currV.getGraph();
        InstructionList iList = method.getInstructionList();
        InstructionHandle currHandle = iList.getStart();
        Instruction inst = currHandle.getInstruction();
        int pos = currHandle.getPosition();
        InstructionList vIList = currV.getInstructionList();
        while (currHandle != null) {
            Edge otherEdge;
            if (startBlock) {
                startBlock = false;
                currV = e == null ? (!blox.exists(pos) ? new CodeVertex(currGraph, pos) : blox.get(pos)) : blox.find(pos, currGraph, e);
                if (lineTab != null) {
                    currV.setStartLine(lineTab.getSourceLine(pos));
                }
                e = currV.getEdge();
                currGraph = (ControlFlowGraph)currV.getGraph();
                vIList = currV.getInstructionList();
            }
            if (inst instanceof GotoInstruction) {
                otherEdge = currV.makeBinary();
                currV.setConnInst(inst);
                int tpos = ((GotoInstruction)inst).getTarget().getPosition();
                int endTry = this.ts == null ? -1 : this.ts.getEndTry(currGraph);
                if (endTry >= 0 && tpos > endTry) {
                    Exit currExit = currGraph.getExit();
                    otherEdge.setTarget(currExit);
                    if (!blox.exists(tpos)) {
                        Vertex vFinal = currExit;
                        while (((Vertex)vFinal).getTarget() instanceof Entry) {
                            vFinal = ((Vertex)vFinal).getTarget();
                        }
                        blox.add(tpos, ((Vertex)vFinal).getEdge());
                    }
                } else {
                    blox.find(tpos, currGraph, otherEdge);
                }
                startBlock = true;
            } else if (inst instanceof IfInstruction || inst instanceof JSR) {
                otherEdge = currV.makeBinary();
                currV.setConnInst(inst);
                int tpos = ((BranchInstruction)inst).getTarget().getPosition();
                blox.find(tpos, currGraph, otherEdge);
                startBlock = true;
            } else if (inst instanceof ReturnInstruction || inst instanceof RET) {
                currV.setConnInst(inst);
                e = null;
                startBlock = true;
            } else if (inst instanceof InvokeInstruction) {
                currV.setConnInst(inst);
                startBlock = true;
            } else if (inst instanceof Select) {
                InstructionHandle[] targets = ((Select)inst).getTargets();
                ComplexConnector conn = currV.makeComplex(targets.length);
                currV.setConnInst(inst);
                int i = 0;
                while (i < targets.length) {
                    int tpos = targets[i].getPosition();
                    blox.find(tpos, currGraph, conn.getEdge(i));
                    ++i;
                }
                InstructionHandle theDefault = ((Select)inst).getTarget();
                if (theDefault != null) {
                    blox.find(theDefault.getPosition(), currGraph, conn.getEdge());
                }
                e = null;
                startBlock = true;
            } else if (inst instanceof ExceptionThrower) {
                currV.setConnInst(inst);
                startBlock = true;
            } else {
                vIList.append(inst);
            }
            InstructionHandle nextHandle = currHandle.getNext();
            if (nextHandle != null && GraphTransformer.hasInbound(nextHandle)) {
                startBlock = true;
            }
            if (startBlock && lineTab != null) {
                currV.setEndLine(lineTab.getSourceLine(0));
            }
            if ((currHandle = nextHandle) == null) continue;
            pos = currHandle.getPosition();
            inst = currHandle.getInstruction();
        }
        return cfg;
    }

    public static final boolean hasInbound(InstructionHandle ih) {
        if (ih.hasTargeters()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            int j = 0;
            while (j < targeters.length) {
                if (targeters[j] instanceof BranchInstruction) {
                    return true;
                }
                if (targeters[j] instanceof CodeExceptionGen) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected final BytecodeCollector collapseGraph(ControlFlowGraph graph) {
        BytecodeCollector theMan = new BytecodeCollector();
        new Walker().visit(graph, theMan);
        return theMan;
    }
}

