/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.Hashtable;
import java.util.List;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.quilt.cl.GraphTransformer;
import org.quilt.cl.MethodXformer;

public class MethodTransformer {
    private Hashtable methodHash = new Hashtable();
    private List mxf;
    private List gxf;
    private GraphTransformer xformer;

    public MethodTransformer(List mxf, List gxf) {
        this.mxf = mxf;
        this.gxf = gxf;
        this.xformer = new GraphTransformer(gxf);
    }

    public Hashtable getMethodHash() {
        return this.methodHash;
    }

    private void zapMethodXformer(MethodXformer mxf, Exception e) {
        System.err.println("WARNING: exception in " + mxf.getName() + ": transformation will not be applied");
        e.printStackTrace();
        mxf = null;
    }

    public MethodGen xform(ClassGen clazz, Method orig) {
        if (orig == null) {
            throw new IllegalArgumentException("null method");
        }
        MethodGen method = new MethodGen(orig, clazz.getClassName(), clazz.getConstantPool());
        MethodXformer[] xf = new MethodXformer[this.mxf.size()];
        int i = 0;
        while (i < xf.length) {
            try {
                xf[i] = (MethodXformer)this.mxf.get(i).getClass().newInstance();
            }
            catch (IllegalAccessException e) {
                this.zapMethodXformer(xf[i], e);
            }
            catch (InstantiationException e) {
                this.zapMethodXformer(xf[i], e);
            }
            if (xf[i] != null && method != null) {
                xf[i].preGraph(clazz, method);
            }
            ++i;
        }
        if (this.gxf.size() > 0 && method != null) {
            InstructionList ilist = this.xformer.xform(clazz, method);
            if (ilist == null) {
                System.out.println("MethodTransformer.xformer: WARNING: xformer returned null instruction list");
                return null;
            }
            method.removeExceptionHandlers();
            ilist.setPositions(true);
            method.setInstructionList(ilist);
            CodeExceptionGen[] cgs = this.xformer.getExceptionHandlers();
            int i2 = 0;
            while (i2 < cgs.length) {
                System.out.println("adding exception " + i2 + " to method " + method.getName() + ": [" + cgs[i2].getStartPC().getPosition() + ".." + cgs[i2].getEndPC().getPosition() + "] --> " + cgs[i2].getHandlerPC().getPosition());
                method.addExceptionHandler(cgs[i2].getStartPC(), cgs[i2].getEndPC(), cgs[i2].getHandlerPC(), cgs[i2].getCatchType());
                ++i2;
            }
            method.removeNOPs();
            method.update();
            try {
                method.setMaxStack();
                method.setMaxLocals();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                System.out.println("GraphTransformer.xformer:\n    EXCEPTION finishing method " + e);
                throw e;
            }
        }
        int i3 = xf.length - 1;
        while (i3 >= 0) {
            if (xf[i3] != null && method != null) {
                xf[i3].postGraph(clazz, method);
            }
            --i3;
        }
        return method;
    }

    void dumpExceptionHandlers(MethodGen method, String where, int len) {
        CodeExceptionGen[] handlers = method.getExceptionHandlers();
        if (handlers.length != len) {
            System.out.println("EXPECTED " + len + " exception handlers, found " + handlers.length);
        }
        if (handlers.length > 0) {
            System.out.println("Exception handlers for method " + method.getName() + " " + where + ":");
            int j = 0;
            while (j < handlers.length) {
                System.out.println("    " + j + ": [" + handlers[j].getStartPC().getPosition() + ".." + handlers[j].getEndPC().getPosition() + "] --> " + handlers[j].getHandlerPC().getPosition());
                ++j;
            }
        }
    }

    void dumpIList(MethodGen method, String where) {
        InstructionList myList = method.getInstructionList();
        System.out.println("MethodTransformer: instruction list " + where + ":");
        int i = 0;
        InstructionHandle ih = myList.getStart();
        while (ih != null) {
            System.out.println("  " + i++ + "  " + ih);
            ih = ih.getNext();
        }
    }
}

