/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.quilt.cl.ClassFactory;
import org.quilt.cl.ClassTransformer;
import org.quilt.cl.ClassXformer;
import org.quilt.cl.GraphXformer;
import org.quilt.cl.MethodXformer;
import org.quilt.reg.QuiltRegistry;

public class QuiltClassLoader
extends URLClassLoader {
    public static final char FILE_PATH_DELIM_CHAR = File.separatorChar;
    public static final String FILE_PATH_DELIM_STR = File.separator;
    public static final char CLASSPATH_DELIM_CHAR = File.pathSeparatorChar;
    public static final String CLASSPATH_DELIM_STR = File.pathSeparator;
    public static final String[] DELEGATED = new String[]{"java.", "javax.", "junit.", "org.apache.bcel.", "org.apache.tools.ant.", "org.quilt.", "sun."};
    private String[] dels = DELEGATED;
    private List delegated = new Vector();
    private List excluded = new Vector();
    private List included = new Vector();
    private List classPath = new Vector();
    private ClassLoader parent = null;
    public static final String SYNTH_PREFIX = "test.data.Test";
    private String synthPrefix = "test.data.Test";
    private boolean synthEnabled = false;
    public ClassTransformer xformer = null;
    List cxf = new Vector();
    List mxf = new Vector();
    List gxf = new Vector();
    List regList = new Vector();
    public static final String THIS_DIR = "." + FILE_PATH_DELIM_STR;
    public static final String UP_DIR = ".." + FILE_PATH_DELIM_STR;
    public static final int THIS_DIR_LEN = THIS_DIR.length();
    public static final int UP_DIR_LEN = UP_DIR.length();
    public Map regMap = new Hashtable();
    static /* synthetic */ Class class$org$quilt$cl$QuiltClassLoader;

    public QuiltClassLoader(URL[] cp, String[] inc) {
        this(cp, null, null, inc, null);
    }

    public QuiltClassLoader(URL[] cp, ClassLoader parent, String[] del, String[] inc, String[] exc) {
        super(cp == null ? new URL[]{} : cp, parent);
        int i;
        int i2;
        if (cp != null) {
            i2 = 0;
            while (i2 < cp.length) {
                this.classPath.add(cp[i2]);
                ++i2;
            }
        }
        this.parent = parent == null ? ClassLoader.getSystemClassLoader() : parent;
        i2 = 0;
        while (i2 < this.dels.length) {
            this.delegated.add(this.dels[i2]);
            ++i2;
        }
        if (del != null) {
            i = 0;
            while (i < del.length) {
                this.delegated.add(del[i]);
                ++i;
            }
        }
        if (inc != null) {
            i = 0;
            while (i < inc.length) {
                this.included.add(inc[i]);
                ++i;
            }
        }
        if (exc != null) {
            i = 0;
            while (i < exc.length) {
                this.excluded.add(exc[i]);
                ++i;
            }
        }
    }

    private boolean delegateTheClass(String name) {
        if (name.equals("org.quilt.QIC")) {
            return false;
        }
        int i = 0;
        while (i < this.delegated.size()) {
            if (name.startsWith((String)this.delegated.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean instrumentTheClass(String name) {
        if (name.equals("org.quilt.QIC")) {
            return false;
        }
        int i = 0;
        while (i < this.excluded.size()) {
            if (name.startsWith((String)this.excluded.get(i))) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.included.size()) {
            if (name.startsWith((String)this.included.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static String classFileName(String className) {
        return className.replace('.', FILE_PATH_DELIM_CHAR) + ".class";
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("null class name");
        }
        if (this.delegateTheClass(name)) {
            return this.parent.loadClass(name);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.xformer == null) {
            this.xformer = new ClassTransformer(this.cxf, this.mxf, this.gxf);
        }
        return this.findClass(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        boolean instIt = this.instrumentTheClass(name) && (this.cxf.size() > 0 || this.mxf.size() > 0 || this.gxf.size() > 0);
        byte[] b = null;
        if (name.startsWith(this.synthPrefix)) {
            JavaClass jc = ClassFactory.getInstance().makeClass(name, QuiltClassLoader.classFileName(name)).getJavaClass();
            if (instIt) {
                jc = this.xformer.xform(jc);
            }
            b = jc.getBytes();
        } else {
            try {
                b = this.getClassData(name);
                if (instIt) {
                    JavaClass jc = new ClassParser((InputStream)new ByteArrayInputStream(b), QuiltClassLoader.classFileName(name)).parse();
                    JavaClass temp = this.xformer.xform(jc);
                    b = temp.getBytes();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ClassNotFoundException(name, e);
            }
        }
        return this.defineClass(name, b, 0, b.length);
    }

    public String urlsToString() {
        StringBuffer sb = new StringBuffer().append("classpath:\n");
        URL[] urls = this.getURLs();
        int k = 0;
        while (k < urls.length) {
            sb.append("    ").append(k).append("  ").append(urls[k]).append("\n");
            ++k;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] getClassData(String className) throws IOException {
        int count;
        URL fileURL = this.findResource(QuiltClassLoader.classFileName(className));
        if (fileURL == null) {
            System.err.println("QCL.getClassData mapping " + className + " to " + QuiltClassLoader.classFileName(className));
            System.err.println("    findResource returned null\n" + this.urlsToString());
        }
        if (fileURL == null) {
            throw new IOException("null fileURL for " + className);
        }
        InputStream ins = fileURL.openStream();
        ByteArrayOutputStream outs = new ByteArrayOutputStream(65536);
        byte[] buffer = new byte[4096];
        while ((count = ins.read(buffer)) != -1) {
            void var6_6;
            outs.write(buffer, 0, (int)var6_6);
        }
        return outs.toByteArray();
    }

    public void addPath(URL url) {
        this.classPath.add(url);
    }

    public URL[] getClassPath() {
        URL[] myURLs = new URL[this.classPath.size()];
        return this.classPath.toArray(myURLs);
    }

    public static String domainToFileName(String name) {
        int startNdx = 0;
        while (startNdx < name.length()) {
            if (name.substring(startNdx).startsWith(THIS_DIR)) {
                startNdx += THIS_DIR_LEN;
                continue;
            }
            if (!name.substring(startNdx).startsWith(UP_DIR)) break;
            startNdx += UP_DIR_LEN;
        }
        int endNdx = name.endsWith(".jar") ? name.length() - 4 : name.length();
        StringBuffer sb = new StringBuffer();
        if (startNdx > 0) {
            sb.append(name.substring(0, startNdx));
        }
        sb.append(name.substring(startNdx, endNdx).replace('.', FILE_PATH_DELIM_CHAR));
        if (endNdx != name.length()) {
            sb.append(".jar");
        }
        return sb.toString();
    }

    public static URL[] cpToURLs(String cp) {
        URL[] urls;
        if (cp == null) {
            urls = new URL[]{};
        } else {
            String[] elements = cp.split(":");
            Vector<URL> urlList = new Vector<URL>();
            int urlCount = 0;
            int i = 0;
            while (i < elements.length) {
                String noDots = QuiltClassLoader.domainToFileName(elements[i]);
                boolean foundJar = noDots.endsWith(".jar");
                File file = new File(noDots);
                String urlForm = "file://" + file.getAbsolutePath();
                if (!foundJar && !urlForm.endsWith(FILE_PATH_DELIM_STR)) {
                    urlForm = urlForm + FILE_PATH_DELIM_STR;
                }
                try {
                    URL candidate = new URL(urlForm);
                    ++urlCount;
                    urlList.add(candidate);
                }
                catch (MalformedURLException e) {
                    System.err.println("WARNING: ignoring malformed URL " + urlForm);
                }
                ++i;
            }
            urls = new URL[urlCount];
            int k = 0;
            while (k < urls.length) {
                urls[k] = (URL)urlList.get(k);
                ++k;
            }
        }
        return urls;
    }

    public void setClassPath(String cp) {
        this.classPath.clear();
        URL[] urls = QuiltClassLoader.cpToURLs(cp);
        int i = 0;
        while (i < urls.length) {
            this.classPath.add(urls[i]);
            this.addURL(urls[i]);
            ++i;
        }
    }

    public void addDelegated(String prefix) {
        this.delegated.add(prefix);
    }

    public String[] getDelegated() {
        String[] myDels = new String[this.delegated.size()];
        return this.delegated.toArray(myDels);
    }

    public void addExcluded(String prefix) {
        this.excluded.add(prefix);
    }

    public String[] getExcluded() {
        String[] myExc = new String[this.excluded.size()];
        return this.excluded.toArray(myExc);
    }

    public void setExcluded(String s) {
        this.excluded.clear();
        if (s != null) {
            String[] newExc = s.split(",");
            int i = 0;
            while (i < newExc.length) {
                this.excluded.add(newExc[i]);
                ++i;
            }
        }
    }

    public void addIncluded(String prefix) {
        this.included.add(prefix);
    }

    public String[] getIncluded() {
        String[] myInc = new String[this.included.size()];
        return this.included.toArray(myInc);
    }

    public void setIncluded(String s) {
        this.included.clear();
        if (s != null) {
            String[] newInc = s.split(",");
            int i = 0;
            while (i < newInc.length) {
                this.included.add(newInc[i]);
                ++i;
            }
        }
    }

    public boolean getSynthEnabled() {
        return this.synthEnabled;
    }

    public void setSynthEnabled(boolean b) {
        this.synthEnabled = b;
    }

    public String getSynthPrefix() {
        return this.synthPrefix;
    }

    public void addClassXformer(ClassXformer xf) {
        this.cxf.add(xf);
    }

    public void addMethodXformer(MethodXformer xf) {
        this.mxf.add(xf);
    }

    public void addGraphXformer(GraphXformer xf) {
        this.gxf.add(xf);
    }

    public QuiltRegistry getRegistry(String regName) {
        QuiltRegistry qr = null;
        if (this.regMap.containsKey(regName)) {
            qr = (QuiltRegistry)this.regMap.get(regName);
        }
        return qr;
    }

    public QuiltRegistry addQuiltRegistry(String regName) {
        QuiltRegistry qr = null;
        if (this.regMap.containsKey(regName)) {
            qr = (QuiltRegistry)this.regMap.get(regName);
        } else {
            try {
                Class<?> o = Class.forName(regName, false, this.parent);
                Constructor<?> con = o.getConstructor(class$org$quilt$cl$QuiltClassLoader == null ? (class$org$quilt$cl$QuiltClassLoader = QuiltClassLoader.class$("org.quilt.cl.QuiltClassLoader")) : class$org$quilt$cl$QuiltClassLoader);
                qr = (QuiltRegistry)con.newInstance(this);
                this.regList.add(qr);
                this.regMap.put(regName, qr);
            }
            catch (Exception e) {
                System.out.println("\nQuiltClassLoader.addQuiltRegistry:\n    EXCEPTION while trying to add " + regName + "\n    Is it on the parent's CLASSPATH?" + "\n    Exception: " + e);
            }
        }
        return qr;
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer();
        if (!this.regList.isEmpty()) {
            Iterator i = this.regList.iterator();
            while (i.hasNext()) {
                QuiltRegistry reg = (QuiltRegistry)i.next();
                sb.append(reg.getReport());
            }
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

