/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.cl.GraphBuildException;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Exit;
import org.quilt.graph.Vertex;

public class SortedBlocks {
    private ControlFlowGraph graph;
    private SortedMap blox = new TreeMap();

    public boolean add(CodeVertex v) {
        int pos = -1;
        if (v == null) {
            throw new IllegalArgumentException("attempt to add null vertex");
        }
        pos = v.getPosition();
        if (pos < 0) {
            throw new IllegalArgumentException("vertex has invalid position");
        }
        Integer p = new Integer(pos);
        if (this.blox.containsKey(p)) {
            return false;
        }
        this.blox.put(p, v);
        return true;
    }

    public CodeVertex find(int pos, ControlFlowGraph currGraph, Edge e) {
        Integer p = new Integer(pos);
        if (this.blox.containsKey(p)) {
            CodeVertex v = (CodeVertex)this.blox.get(p);
            ControlFlowGraph vGraph = (ControlFlowGraph)v.getGraph();
            if (vGraph == currGraph) {
                e.setTarget(v);
            } else {
                Entry x = currGraph.closestEntry(vGraph);
                if (x != null) {
                    e.setTarget(x);
                } else {
                    e.setTarget(currGraph.getExit());
                }
            }
            return v;
        }
        return this.add(pos, e);
    }

    public CodeVertex add(int pos, Edge e) {
        Integer p = new Integer(pos);
        Vertex source_ = e.getSource();
        CodeVertex v = source_ instanceof Exit ? ((ControlFlowGraph)e.getTarget().getGraph()).insertCodeVertex(e) : ((ControlFlowGraph)source_.getGraph()).insertCodeVertex(e);
        v.setPos(pos);
        this.blox.put(p, v);
        return v;
    }

    public boolean exists(int pos) {
        Integer p = new Integer(pos);
        return this.blox.containsKey(p);
    }

    public CodeVertex get(int pos) {
        Integer p = new Integer(pos);
        if (!this.blox.containsKey(p)) {
            throw new GraphBuildException("INTERNAL ERROR - no vertex at " + pos);
        }
        return (CodeVertex)this.blox.get(p);
    }

    public int size() {
        return this.blox.size();
    }

    public String toString() {
        Iterator vertices = this.blox.keySet().iterator();
        String s = "vertex  position / instructions\n";
        while (vertices.hasNext()) {
            Integer position = (Integer)vertices.next();
            CodeVertex v = (CodeVertex)this.blox.get(position);
            s = s + "  " + v.getIndex() + "     " + position + "\n" + v;
        }
        return s;
    }
}

