/*
 * Decompiled with CFR 0.152.
 */
package org.quilt.cl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ObjectType;
import org.quilt.cl.CatchData;
import org.quilt.cl.CodeVertex;
import org.quilt.cl.ControlFlowGraph;
import org.quilt.cl.SortedBlocks;
import org.quilt.graph.ComplexConnector;
import org.quilt.graph.Edge;
import org.quilt.graph.Entry;
import org.quilt.graph.Vertex;

public class TryStacks {
    private ControlFlowGraph graph = null;
    private SortedBlocks blox = null;
    private int handlerCount = 0;
    private int index;
    private int[] tryStart;
    private int[] tryEnd;
    private int[] handlerPC;
    private ObjectType[] exception;
    private boolean[] done;
    private Map tryEndNdx = new HashMap();

    public TryStacks(CodeExceptionGen[] handlers, SortedBlocks blocks, ControlFlowGraph g) {
        if (handlers == null || blocks == null || g == null) {
            throw new IllegalArgumentException("null constructor argument");
        }
        this.blox = blocks;
        this.graph = g;
        this.handlerCount = handlers.length;
        if (this.handlerCount > 0) {
            int i;
            this.tryStart = new int[this.handlerCount];
            this.tryEnd = new int[this.handlerCount];
            this.handlerPC = new int[this.handlerCount];
            this.exception = new ObjectType[this.handlerCount];
            this.done = new boolean[this.handlerCount];
            TreeMap<CodeExceptionGen, Integer> sm = new TreeMap<CodeExceptionGen, Integer>(new CmpHandlers());
            int i2 = 0;
            while (i2 < this.handlerCount) {
                sm.put(handlers[i2], new Integer(i2));
                ++i2;
            }
            Iterator it = sm.keySet().iterator();
            int j = 0;
            while (it.hasNext()) {
                Integer iInt = (Integer)sm.get((CodeExceptionGen)it.next());
                i = iInt;
                this.tryStart[j] = handlers[i].getStartPC().getPosition();
                this.tryEnd[j] = handlers[i].getEndPC().getPosition();
                this.handlerPC[j] = handlers[i].getHandlerPC().getPosition();
                this.exception[j] = handlers[i].getCatchType();
                this.done[j] = false;
                ++j;
            }
            Edge edge = this.graph.getEntry().getEdge();
            i = 0;
            while (i < this.handlerCount && !this.done[i]) {
                ControlFlowGraph sub = this.handleTry(this.graph, edge);
                edge = sub.getExit().getEdge();
            }
        }
    }

    private ControlFlowGraph handleTry(ControlFlowGraph g, Edge parentEdge) {
        ControlFlowGraph subsub;
        int start = this.tryStart[this.index];
        int end = this.tryEnd[this.index];
        if (parentEdge == null) {
            throw new IllegalArgumentException("null edge");
        }
        ControlFlowGraph subgraph = this.handleTryGroup(g, parentEdge);
        Entry subEntry = subgraph.getEntry();
        Edge currEdge = ((Vertex)subEntry).getEdge();
        if (this.index < this.handlerCount && this.tryStart[this.index] == start) {
            subsub = this.handleTry(subgraph, currEdge);
            currEdge = subsub.getExit().getEdge();
        } else {
            currEdge = this.blox.add(this.tryStart[this.index - 1], currEdge).getEdge();
        }
        boolean nested = false;
        while (this.index < this.handlerCount && this.tryStart[this.index] < end) {
            subsub = this.handleTry(subgraph, currEdge);
            currEdge = subsub.getExit().getEdge();
        }
        this.tryEndNdx.put(subgraph, new Integer(start));
        return subgraph;
    }

    private ControlFlowGraph handleTryGroup(ControlFlowGraph parent, Edge parentEdge) {
        int k = 1;
        int pos = this.tryStart[this.index];
        int end = this.tryEnd[this.index];
        int j = this.index + 1;
        while (j < this.handlerCount && this.tryStart[j] == pos && this.tryEnd[j] == end) {
            ++k;
            ++j;
        }
        ControlFlowGraph subgraph = (ControlFlowGraph)parent.subgraph(parentEdge, k);
        Edge currentEdge = subgraph.getExit().getEdge();
        ComplexConnector conn = (ComplexConnector)subgraph.getEntry().getConnector();
        int j2 = 0;
        while (j2 < k) {
            this.done[this.index + j2] = true;
            Edge edge = conn.getEdge(j2);
            CodeVertex v = subgraph.insertCodeVertex(edge);
            v.setPos(this.handlerPC[this.index + j2]);
            this.blox.add(v);
            ++j2;
        }
        this.index += k;
        return subgraph;
    }

    public CatchData[] getCatchData() {
        CatchData[] cd = new CatchData[this.tryStart.length];
        int i = 0;
        while (i < this.tryStart.length) {
            cd[i] = new CatchData(this.blox.get(this.tryStart[i]), this.blox.get(this.tryEnd[i]), this.blox.get(this.handlerPC[i]), this.exception[i]);
            ++i;
        }
        return cd;
    }

    public Comparator getComparator() {
        return new CmpHandlers();
    }

    int getEndTry(ControlFlowGraph graph) {
        if (this.tryEndNdx.containsKey(graph)) {
            Integer i = (Integer)this.tryEndNdx.get(graph);
            return i;
        }
        return -1;
    }

    public String toString() {
        String s = "";
        if (this.handlerCount > 0) {
            s = "  index start end handler pc\n";
            int i = 0;
            while (i < this.handlerCount) {
                s = s + "    " + i + "    [" + this.tryStart[i] + ".." + this.tryEnd[i] + "] --> " + this.handlerPC[i] + "\n";
                ++i;
            }
        }
        return s;
    }

    private class CmpHandlers
    implements Comparator {
        private CmpHandlers() {
        }

        public int compare(Object o1, Object o2) {
            int bHandler;
            int bEnd;
            int bStart;
            CodeExceptionGen a = (CodeExceptionGen)o1;
            CodeExceptionGen b = (CodeExceptionGen)o2;
            int aStart = a.getStartPC().getPosition();
            if (aStart < (bStart = b.getStartPC().getPosition())) {
                return -1;
            }
            if (aStart > bStart) {
                return 1;
            }
            int aEnd = a.getEndPC().getPosition();
            if (aEnd < (bEnd = b.getEndPC().getPosition())) {
                return 1;
            }
            if (aEnd > bEnd) {
                return -1;
            }
            int aHandler = a.getHandlerPC().getPosition();
            if (aHandler < (bHandler = b.getHandlerPC().getPosition())) {
                return -1;
            }
            if (aHandler > bHandler) {
                return 1;
            }
            return 0;
        }
    }
}

